/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop;

import com.mule.connectors.interop.Utils;
import com.mule.connectors.interop.exception.TestDataParserException;
import com.mule.connectors.interop.exceptions.CreatorMojoException;
import com.mule.connectors.interop.exceptions.ManifestUpdateException;
import com.mule.connectors.interop.exceptions.TargetPlatformUpdateException;
import com.mule.connectors.interop.model.DependenciesPom;
import com.mule.connectors.interop.model.ManifestFile;
import com.mule.connectors.interop.model.TargetPlatform;
import com.mule.connectors.interop.model.TestDataFile;
import com.mule.connectors.interop.model.UpdateSite;
import com.mule.connectors.interop.parser.TestDataParser;
import com.mule.connectors.testdata.model.TestData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="create", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(goal="create")
public class RunnerCreatorMojo
extends AbstractMojo {
    public static final String RELATIVE_TEST_RESOURCES_PATH = "src/test/resources/";
    public static final String GENERATED_TEST_RESOURCES_PATH = "interop-ce-project/ce-interop-testsuite/src/test/resources/";
    private static final String BUNDLE_VERSION_0_0_0 = ";bundle-version=\"0.0.0\"\n";
    private String zipName = "interop-ce-project.zip";
    @Parameter(property="externalPlatform", defaultValue="")
    private String externalPlatform;
    @Parameter(defaultValue="interop-ce-project/ce-interop-testsuite/META-INF/MANIFEST.MF")
    private String manifestPath;
    @Parameter(defaultValue="interop-ce-project/ce-interop-target-platform/ce-interop-target-platform.target")
    private String platformPath;
    @Parameter(property="credentialsPath", defaultValue="")
    private String externalCredentials;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private String targetDir;
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    protected File baseDir;
    private ManifestFile manifest;
    private UpdateSite connectorUpdateSite;
    private TargetPlatform targetPlatform;
    private DependenciesPom dependenciesPom;

    public RunnerCreatorMojo() {
    }

    public RunnerCreatorMojo(File baseDir, String targetDir, String zipPath) {
        this.baseDir = baseDir;
        this.targetDir = targetDir;
        this.zipName = StringUtils.isBlank((String)zipPath) ? this.zipName : zipPath;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Utils.unzipFile(this.targetDir, this.zipName);
        this.initilizeRunnerFiles();
        this.updateManifest();
        this.updateTargetPlatform();
        TestData overridesData = this.getTestDataOverrides();
        this.updateDependenciesPom(overridesData);
        this.copyCredentialsToProjectResources(overridesData);
    }

    public void copyCredentialsToProjectResources(TestData overridesData) {
        try {
            String credentialsName = overridesData.getGlobalConfig().getCredentialsFile();
            if (!StringUtils.isBlank((String)credentialsName)) {
                File credentials = this.getCredentialsFile(credentialsName);
                if (credentials != null && credentials.exists()) {
                    File destination = new File(this.targetDir, GENERATED_TEST_RESOURCES_PATH + credentialsName);
                    FileUtils.copyFile((File)credentials, (File)destination);
                } else {
                    this.getLog().error((CharSequence)("Unable to retrieve the credentials :: " + (credentials != null ? credentials.getCanonicalPath() : " file name was null")));
                }
            }
        }
        catch (IOException e) {
            throw new CreatorMojoException(e);
        }
    }

    private void updateDependenciesPom(TestData overridesData) throws CreatorMojoException {
        if (overridesData.getProperties() != null && overridesData.getProperties().getDependencies() != null) {
            this.dependenciesPom.updateDependencies(overridesData.getProperties().getDependencies());
        }
    }

    private void updateManifest() {
        String bundleLine = " " + this.connectorUpdateSite.getManifestUnit().getId() + BUNDLE_VERSION_0_0_0;
        try {
            this.manifest.updateRequiredBundle(bundleLine);
        }
        catch (ManifestUpdateException e) {
            throw new CreatorMojoException(e);
        }
    }

    private void updateTargetPlatform() {
        try {
            if (!StringUtils.isEmpty((String)this.externalPlatform) && new File(this.externalPlatform).exists()) {
                this.replaceTargetPlatform();
            }
            this.targetPlatform.addLocation(this.connectorUpdateSite);
        }
        catch (IOException e) {
            throw new CreatorMojoException(e);
        }
    }

    private void replaceTargetPlatform() throws IOException {
        FileUtils.forceDelete((File)new File(this.targetDir, this.platformPath));
        FileUtils.copyFile((File)new File(this.externalPlatform), (File)new File(this.targetDir, this.platformPath));
        this.initializeTargetPlatform();
    }

    private void initilizeRunnerFiles() {
        try {
            this.initializeManifest();
            this.initializeTargetPlatform();
            this.initializeUpdateSite();
            this.initializeDependenciesPom();
        }
        catch (IOException e) {
            throw new CreatorMojoException(e);
        }
    }

    private void initializeUpdateSite() throws IOException {
        this.connectorUpdateSite = new UpdateSite(this.targetDir);
    }

    private void initializeTargetPlatform() throws TargetPlatformUpdateException {
        this.targetPlatform = new TargetPlatform(new File(this.targetDir, this.platformPath).getPath());
    }

    private void initializeManifest() {
        this.manifest = new ManifestFile(new File(this.targetDir, this.manifestPath).getPath());
    }

    private void initializeDependenciesPom() {
        this.dependenciesPom = new DependenciesPom(new File(this.targetDir, "interop-ce-project/ce-interop-testsuite/dependenciesPom.xml"));
    }

    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setManifestPath(String manifestPath) {
        this.manifestPath = manifestPath;
    }

    public void setOutputDir(String targetDir) {
        this.targetDir = targetDir;
    }

    public void setPlatformPath(String platformPath) {
        this.platformPath = platformPath;
    }

    public void setExternalPlatform(String externalPlatform) {
        this.externalPlatform = externalPlatform;
    }

    private TestData getTestDataOverrides() {
        try {
            String overridesFilePath = new TestDataFile(this.baseDir, ".*test(d|D)ata.*(o|O)verride?\\.xml").getPath();
            return TestDataParser.unmarshall((InputStream)new FileInputStream(new File(overridesFilePath)));
        }
        catch (IOException e) {
            throw new CreatorMojoException(e);
        }
        catch (TestDataParserException e) {
            throw new CreatorMojoException((Exception)((Object)e));
        }
    }

    private File getCredentialsFile(String credentialsName) {
        if (StringUtils.isBlank((String)credentialsName)) {
            return null;
        }
        File credentials = !StringUtils.isBlank((String)this.externalCredentials) ? new File(this.externalCredentials) : this.getCredentialsFromProjectResources(credentialsName);
        return credentials;
    }

    private File getCredentialsFromProjectResources(String credentialsName) {
        File credentials = new File(credentialsName);
        if (!credentials.exists()) {
            String path = Utils.findFileInFolder(new File(this.baseDir, RELATIVE_TEST_RESOURCES_PATH), credentialsName);
            credentials = path.isEmpty() ? null : new File(path);
        }
        return credentials;
    }

    public void setExternalCredentials(String externalCredentials) {
        this.externalCredentials = externalCredentials;
    }
}

