/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.db.commons.internal.result.statement;

import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;

import java.sql.SQLException;
import java.sql.Statement;

/**
 * Processes the results returned by a {@link Statement} execution
 */
public interface StatementResultHandler {

  /**
   * Processes the results from a statement execution
   *
   * @param connection connection used to execute the statement. Non null
   * @param statement executed statement. Non null
   * @param queryTemplate executed query template. Non null
   * @param autoGenerateKeysStrategy strategy used to process auto generated keys. Non null
   * @return a non null the results of the statement execution
   */
  Object processStatement(DbConnection connection, Statement statement, QueryTemplate queryTemplate,
                          AutoGenerateKeysStrategy autoGenerateKeysStrategy)
      throws SQLException;
}
