/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;
import org.mule.db.commons.internal.result.statement.StatementResultIteratorFactory;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;

public interface DbConnection
extends TransactionalConnection {
    public StatementResultIteratorFactory getStatementResultIteratorFactory(ResultSetHandler var1);

    public List<DbType> getCustomDataTypes();

    public List<DbType> getVendorDataTypes();

    public Connection getJdbcConnection();

    public void release();

    public void beginStreaming();

    public boolean isStreaming();

    public void endStreaming();

    public boolean isTransactionActive();

    public boolean supportsContentStreaming();

    default public Array createArrayOf(String typeName, Object[] values) throws SQLException {
        return this.getJdbcConnection().createArrayOf(typeName, values);
    }

    default public Array createArrayOf(String typeName, Object value) throws SQLException {
        Object[] values = value instanceof Object[] ? (Object[])value : (value instanceof Collection ? ((Collection)value).toArray() : new Object[]{value});
        return this.createArrayOf(typeName, values);
    }

    default public Struct createStruct(String typeName, Object[] values) throws SQLException {
        return this.getJdbcConnection().createStruct(typeName, values);
    }

    default public ResultSet getProcedureColumns(String storedProcedureName, String storedProcedureOwner, String storedProcedureParentOwner, String catalogName) throws SQLException {
        DatabaseMetaData dbMetaData = this.getJdbcConnection().getMetaData();
        if (!StringUtils.isBlank((CharSequence)storedProcedureOwner)) {
            return dbMetaData.getProcedureColumns(catalogName, storedProcedureOwner, storedProcedureName, "%");
        }
        return dbMetaData.getProcedureColumns(catalogName, null, storedProcedureName, "%");
    }

    default public Optional<String> getProcedureColumnType(String procedureName, String columnName, String owner) throws SQLException {
        return Optional.empty();
    }

    default public Set<String> getTables() throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        ResultSet tables = this.getJdbcConnection().getMetaData().getTables(null, null, "%", null);
        while (tables.next()) {
            tableNames.add(tables.getString(3));
        }
        return tableNames;
    }
}

