/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection;

import java.io.InputStream;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.db.commons.api.exception.connection.ConnectionClosingException;
import org.mule.db.commons.api.param.JdbcType;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.connection.type.resolver.ArrayTypeResolver;
import org.mule.db.commons.internal.domain.connection.type.resolver.StructAndArrayTypeResolver;
import org.mule.db.commons.internal.domain.connection.type.resolver.StructTypeResolver;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;
import org.mule.db.commons.internal.result.statement.GenericStatementResultIteratorFactory;
import org.mule.db.commons.internal.result.statement.StatementResultIteratorFactory;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDbConnection
implements DbConnection {
    private final Connection jdbcConnection;
    private final List<DbType> customDataTypes;
    private AtomicInteger streamsCount = new AtomicInteger(0);
    private boolean isTransactionActive = false;
    private static final int DATA_TYPE_INDEX = 5;
    private static final int ATTR_TYPE_NAME_INDEX = 6;
    private static final List<String> LOB_TYPES = Arrays.asList(JdbcType.BLOB.getDbType().getName(), JdbcType.CLOB.getDbType().getName());
    protected static final int UNKNOWN_DATA_TYPE = -1;
    protected static final Logger logger = LoggerFactory.getLogger(DefaultDbConnection.class);

    public DefaultDbConnection(Connection jdbcConnection, List<DbType> customDataTypes) {
        this.jdbcConnection = jdbcConnection;
        this.customDataTypes = customDataTypes;
    }

    @Override
    public StatementResultIteratorFactory getStatementResultIteratorFactory(ResultSetHandler resultSetHandler) {
        return new GenericStatementResultIteratorFactory(resultSetHandler);
    }

    @Override
    public List<DbType> getVendorDataTypes() {
        return Collections.emptyList();
    }

    @Override
    public Connection getJdbcConnection() {
        return this.jdbcConnection;
    }

    @Override
    public List<DbType> getCustomDataTypes() {
        return this.customDataTypes;
    }

    public void begin() throws TransactionException {
        try {
            if (this.jdbcConnection.getAutoCommit()) {
                this.jdbcConnection.setAutoCommit(false);
            }
            this.isTransactionActive = true;
        }
        catch (Exception e) {
            throw new TransactionException(I18nMessageFactory.createStaticMessage((String)("Could not start transaction: " + e.getMessage())), (Throwable)e);
        }
    }

    public void commit() throws TransactionException {
        try {
            this.jdbcConnection.commit();
        }
        catch (Exception e) {
            throw new TransactionException(I18nMessageFactory.createStaticMessage((String)("Could not start transaction: " + e.getMessage())), (Throwable)e);
        }
        finally {
            this.isTransactionActive = false;
            this.abortStreaming();
        }
    }

    public void rollback() throws TransactionException {
        try {
            this.jdbcConnection.rollback();
        }
        catch (Exception e) {
            throw new TransactionException(I18nMessageFactory.createStaticMessage((String)("Could not start transaction: " + e.getMessage())), (Throwable)e);
        }
        finally {
            this.isTransactionActive = false;
            this.abortStreaming();
        }
    }

    @Override
    public void release() {
        if (this.isStreaming()) {
            return;
        }
        try {
            this.jdbcConnection.close();
        }
        catch (SQLException e) {
            throw new ConnectionClosingException(e);
        }
    }

    @Override
    public void beginStreaming() {
        this.streamsCount.incrementAndGet();
    }

    @Override
    public boolean isStreaming() {
        return this.streamsCount.get() > 0;
    }

    @Override
    public void endStreaming() {
        this.streamsCount.getAndUpdate(operand -> operand <= 0 ? 0 : operand - 1);
    }

    private void abortStreaming() {
        this.streamsCount.set(0);
    }

    @Override
    public boolean isTransactionActive() {
        return this.isTransactionActive;
    }

    @Override
    public boolean supportsContentStreaming() {
        return true;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.jdbcConnection.prepareStatement(sql);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.resolveLobs(typeName, elements, new ArrayTypeResolver(this));
        return this.jdbcConnection.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.resolveLobs(typeName, attributes, new StructTypeResolver(this));
        return this.jdbcConnection.createStruct(typeName, attributes);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.jdbcConnection.getMetaData();
    }

    private ResultSet getAttributes(String typeName) throws SQLException {
        return this.getMetaData().getAttributes(this.jdbcConnection.getCatalog(), null, typeName, null);
    }

    protected void resolveLobs(String typeName, Object[] attributes, StructAndArrayTypeResolver typeResolver) throws SQLException {
        block3: {
            try {
                Map<Integer, ResolvedDbType> dataTypes = this.getLobFieldsDataTypeInfo(typeName);
                for (Map.Entry<Integer, ResolvedDbType> entry : dataTypes.entrySet()) {
                    Integer key = entry.getKey();
                    ResolvedDbType dataType = entry.getValue();
                    typeResolver.resolveLobIn(attributes, key, dataType);
                }
            }
            catch (SQLException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Unable to resolve lobs: {}. Proceeding with original attributes.", (Object)e.getMessage());
            }
        }
    }

    protected Map<Integer, ResolvedDbType> getLobFieldsDataTypeInfo(String typeName) throws SQLException {
        HashMap<Integer, ResolvedDbType> dataTypes = new HashMap<Integer, ResolvedDbType>();
        try (ResultSet resultSet = this.getAttributes(typeName);){
            int index = 0;
            while (resultSet.next()) {
                int dataType = resultSet.getInt(5);
                String dataTypeName = resultSet.getString(6);
                if (LOB_TYPES.contains(dataTypeName)) {
                    dataTypes.put(index, new ResolvedDbType(dataType, dataTypeName));
                }
                ++index;
            }
        }
        return dataTypes;
    }

    public void doResolveLobIn(Object[] attributes, int index, int dataType, String dataTypeName) throws SQLException {
        if (this.shouldResolveAttributeWithJdbcType(dataType, dataTypeName, JdbcType.BLOB.getDbType())) {
            attributes[index] = this.createBlob(attributes[index]);
        } else if (this.shouldResolveAttributeWithJdbcType(dataType, dataTypeName, JdbcType.CLOB.getDbType())) {
            attributes[index] = this.createClob(attributes[index]);
        }
    }

    private boolean shouldResolveAttributeWithJdbcType(int dbDataType, String dbDataTypeName, DbType jdbcType) {
        if (dbDataType == -1) {
            return dbDataTypeName.equals(jdbcType.getName());
        }
        return dbDataType == jdbcType.getId();
    }

    public void doResolveLobIn(Object[] attributes, int index, String dataTypeName) throws SQLException {
        this.doResolveLobIn(attributes, index, -1, dataTypeName);
    }

    private Blob createBlob(Object attribute) throws SQLException {
        Blob blob = this.jdbcConnection.createBlob();
        if (attribute instanceof byte[]) {
            blob.setBytes(1L, (byte[])attribute);
        } else if (attribute instanceof InputStream) {
            blob.setBytes(1L, IOUtils.toByteArray((InputStream)((InputStream)attribute)));
        } else if (attribute instanceof String) {
            blob.setBytes(1L, ((String)attribute).getBytes());
        } else {
            throw new IllegalArgumentException(String.format("Cannot create a %s from a value of type '%s'", Struct.class.getName(), attribute.getClass()));
        }
        return blob;
    }

    private Clob createClob(Object attribute) throws SQLException {
        Clob clob = this.jdbcConnection.createClob();
        if (attribute instanceof String) {
            clob.setString(1L, (String)attribute);
        } else if (attribute instanceof InputStream) {
            clob.setString(1L, IOUtils.toString((InputStream)((InputStream)attribute)));
        } else {
            throw new IllegalArgumentException(String.format("Cannot create a %s from a value of type '%s'", Struct.class.getName(), attribute.getClass()));
        }
        return clob;
    }
}

