/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.operation;

import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.db.commons.AbstractDbConnector;
import org.mule.db.commons.api.StatementResult;
import org.mule.db.commons.api.exception.connection.QueryExecutionException;
import org.mule.db.commons.api.param.ParameterizedStatementDefinition;
import org.mule.db.commons.api.param.QueryDefinition;
import org.mule.db.commons.api.param.StoredProcedureCall;
import org.mule.db.commons.internal.StatementStreamingResultSetCloser;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysAttributes;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.executor.QueryExecutor;
import org.mule.db.commons.internal.domain.executor.SelectExecutor;
import org.mule.db.commons.internal.domain.executor.StoredProcedureExecutor;
import org.mule.db.commons.internal.domain.query.Query;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.domain.statement.ConfigurableStatementFactory;
import org.mule.db.commons.internal.operation.BaseDbOperations;
import org.mule.db.commons.internal.resolver.query.ParameterizedQueryResolver;
import org.mule.db.commons.internal.resolver.query.QueryResolver;
import org.mule.db.commons.internal.resolver.query.StoredProcedureQueryResolver;
import org.mule.db.commons.internal.result.resultset.IteratorResultSetHandler;
import org.mule.db.commons.internal.result.resultset.ListResultSetHandler;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;
import org.mule.db.commons.internal.result.resultset.ResultSetIterator;
import org.mule.db.commons.internal.result.resultset.SingleResultSetHandler;
import org.mule.db.commons.internal.result.row.InsensitiveMapRowHandler;
import org.mule.db.commons.internal.result.row.NonStreamingInsensitiveMapRowHandler;
import org.mule.db.commons.internal.result.row.RowHandler;
import org.mule.db.commons.internal.result.statement.StreamingStatementResultHandler;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.operation.FlowListener;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmlOperations
extends BaseDbOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmlOperations.class);
    private final ParameterizedQueryResolver<StoredProcedureCall> storedProcedureResolver;
    protected BiFunction<DbConnection, Charset, RowHandler> selectRowHandlerSupplier;
    protected BiFunction<DbConnection, Charset, RowHandler> querySingleRowHandlerSupplier;
    protected BiFunction<DbConnection, Charset, RowHandler> storedProcedureRowHandlerSupplier;
    protected BiFunction<ConfigurableStatementFactory, ResultSetHandler, QueryExecutor> selectQueryExecutorSupplier;
    protected BiFunction<ConfigurableStatementFactory, ResultSetHandler, QueryExecutor> querySingleQueryExecutorSupplier;

    private DmlOperations(QueryResolver<ParameterizedStatementDefinition> queryResolver, ConfigurableStatementFactory statementFactory, ParameterizedQueryResolver<StoredProcedureCall> storedProcedureResolver, BiFunction<DbConnection, Charset, RowHandler> selectRowHandler, BiFunction<DbConnection, Charset, RowHandler> querySingleRowHandler, BiFunction<DbConnection, Charset, RowHandler> storedProcedureRowHandler, BiFunction<ConfigurableStatementFactory, ResultSetHandler, QueryExecutor> selectQueryExecutor, BiFunction<ConfigurableStatementFactory, ResultSetHandler, QueryExecutor> querySingleQueryExecutor, Function<ConfigurableStatementFactory, QueryExecutor> updateExecutor) {
        super(queryResolver, statementFactory, updateExecutor);
        this.storedProcedureResolver = storedProcedureResolver;
        this.selectRowHandlerSupplier = selectRowHandler;
        this.querySingleRowHandlerSupplier = querySingleRowHandler;
        this.storedProcedureRowHandlerSupplier = storedProcedureRowHandler;
        this.selectQueryExecutorSupplier = selectQueryExecutor;
        this.querySingleQueryExecutorSupplier = querySingleQueryExecutor;
    }

    protected static ParameterizedQueryResolver<StoredProcedureCall> getDefaultStoredProcedureResolver() {
        return new StoredProcedureQueryResolver();
    }

    protected static BiFunction<DbConnection, Charset, RowHandler> getDefaultInsensitiveMapRowHandler() {
        return InsensitiveMapRowHandler::new;
    }

    protected static BiFunction<DbConnection, Charset, RowHandler> getDefaultNonStreamingInsensitiveMapRowHandler() {
        return NonStreamingInsensitiveMapRowHandler::new;
    }

    protected static BiFunction<ConfigurableStatementFactory, ResultSetHandler, QueryExecutor> getDefaultSelectExecutor() {
        return SelectExecutor::new;
    }

    public PagingProvider<DbConnection, Map<String, Object>> select(final QueryDefinition query, final AbstractDbConnector connector, final StreamingHelper streamingHelper, final FlowListener flowListener) throws SQLException {
        return new PagingProvider<DbConnection, Map<String, Object>>(){
            private final AtomicBoolean initialised = new AtomicBoolean(false);
            private ResultSetIterator iterator;
            private StatementStreamingResultSetCloser resultSetCloser;

            public List<Map<String, Object>> getPage(DbConnection connection) {
                ResultSetIterator it = this.getIterator(connection, connector);
                int fetchSize = DmlOperations.this.getFetchSize(query);
                ArrayList<Map<String, Object>> page = new ArrayList<Map<String, Object>>(fetchSize);
                for (int i = 0; i < fetchSize && it.hasNext(); ++i) {
                    page.add(DmlOperations.this.resolveResultStreams((Map)it.next(), streamingHelper));
                }
                return page;
            }

            public Optional<Integer> getTotalResults(DbConnection connection) {
                return Optional.empty();
            }

            public void close(DbConnection connection) throws MuleException {
                this.resultSetCloser.closeResultSets();
            }

            private ResultSetIterator getIterator(DbConnection connection, AbstractDbConnector connector2) {
                if (this.initialised.compareAndSet(false, true)) {
                    this.resultSetCloser = new StatementStreamingResultSetCloser(connection);
                    flowListener.onError((Consumer)new ResultSetCloserExceptionConsumer(this.resultSetCloser, query.getSql()));
                    Query resolvedQuery = DmlOperations.this.resolveQuery(query, connector2, connection, streamingHelper, QueryType.SELECT, QueryType.STORE_PROCEDURE_CALL);
                    ConfigurableStatementFactory statementFactory = DmlOperations.this.getStatementFactory(query);
                    RowHandler recordHandler = DmlOperations.this.selectRowHandlerSupplier.apply(connection, connector2.getCharset());
                    IteratorResultSetHandler resultSetHandler = new IteratorResultSetHandler(recordHandler, this.resultSetCloser, connector2.getCharset());
                    try {
                        this.iterator = (ResultSetIterator)DmlOperations.this.selectQueryExecutorSupplier.apply(statementFactory, resultSetHandler).execute(connection, resolvedQuery);
                    }
                    catch (SQLException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                }
                return this.iterator;
            }

            public boolean useStickyConnections() {
                return true;
            }
        };
    }

    public Map<String, Object> querySingle(QueryDefinition query, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        Query resolvedQuery = this.resolveQuery(query, connector, connection, streamingHelper, QueryType.SELECT);
        ConfigurableStatementFactory statementFactory = this.getStatementFactory(query);
        RowHandler recordHandler = this.querySingleRowHandlerSupplier.apply(connection, connector.getCharset());
        SingleResultSetHandler resultSetHandler = new SingleResultSetHandler(recordHandler, connector.getCharset());
        try {
            return (Map)this.querySingleQueryExecutorSupplier.apply(statementFactory, resultSetHandler).execute(connection, resolvedQuery);
        }
        catch (SQLException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public StatementResult insert(QueryDefinition query, AutoGenerateKeysAttributes autoGenerateKeysAttributes, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        Query resolvedQuery = this.resolveQuery(query, connector, connection, streamingHelper, QueryType.INSERT);
        return this.executeUpdate(query, autoGenerateKeysAttributes, connection, resolvedQuery);
    }

    public StatementResult update(QueryDefinition query, AutoGenerateKeysAttributes autoGenerateKeysAttributes, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        Query resolvedQuery = this.resolveQuery(query, connector, connection, streamingHelper, QueryType.UPDATE, QueryType.TRUNCATE, QueryType.MERGE, QueryType.STORE_PROCEDURE_CALL);
        return this.executeUpdate(query, autoGenerateKeysAttributes, connection, resolvedQuery);
    }

    public int delete(QueryDefinition query, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper) throws SQLException {
        Query resolvedQuery = this.resolveQuery(query, connector, connection, streamingHelper, QueryType.DELETE);
        return this.executeUpdate(query, null, connection, resolvedQuery).getAffectedRows();
    }

    public Map<String, Object> storedProcedure(StoredProcedureCall call, AutoGenerateKeysAttributes autoGenerateKeysAttributes, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper, FlowListener flowListener) throws SQLException {
        Map result;
        Query resolvedQuery = this.resolveQuery(call, connector, connection, streamingHelper, QueryType.STORE_PROCEDURE_CALL);
        ConfigurableStatementFactory statementFactory = this.getStatementFactory(call);
        Charset charset = connector.getCharset();
        RowHandler recordHandler = this.storedProcedureRowHandlerSupplier.apply(connection, charset);
        StatementStreamingResultSetCloser resultSetCloser = new StatementStreamingResultSetCloser(connection);
        flowListener.onComplete((Runnable)new ResultSetCloserRunnable(resultSetCloser));
        StreamingStatementResultHandler resultHandler = connection.getJdbcConnection().getMetaData().supportsMultipleOpenResults() ? new StreamingStatementResultHandler(new IteratorResultSetHandler(recordHandler, resultSetCloser, charset)) : new StreamingStatementResultHandler(new ListResultSetHandler(recordHandler, charset));
        try {
            result = (Map)new StoredProcedureExecutor(statementFactory, resultHandler).execute(connection, resolvedQuery, this.getAutoGeneratedKeysStrategy(autoGenerateKeysAttributes));
        }
        catch (SQLException e) {
            throw new QueryExecutionException(e.getMessage(), e);
        }
        if (!connection.isTransactionActive()) {
            connection.release();
        }
        return this.resolveResultStreams(result, streamingHelper);
    }

    protected Query resolveQuery(StoredProcedureCall call, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper, QueryType ... validTypes) {
        Query resolvedQuery = this.storedProcedureResolver.resolve(call, connector, connection, streamingHelper);
        this.validateQueryType(resolvedQuery.getQueryTemplate(), Arrays.asList(validTypes));
        return resolvedQuery;
    }

    private Map<String, Object> resolveResultStreams(Map<String, Object> map, StreamingHelper streamingHelper) {
        return this.resolveMap(map, true, streamingHelper);
    }

    private <K> Map<K, Object> resolveMap(Map<K, Object> map, boolean recursive, StreamingHelper streamingHelper) {
        Map<K, Object> resolved;
        Preconditions.checkArgument((map != null ? 1 : 0) != 0, (String)"Map cannot be null");
        try {
            resolved = (Map)ClassUtils.instantiateClass(map.getClass(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            resolved = new LinkedHashMap();
        }
        for (Map.Entry<K, Object> entry : map.entrySet()) {
            Object value = DmlOperations.resolveCursorProvider(entry.getValue(), streamingHelper);
            if (recursive && value instanceof Map) {
                value = streamingHelper.resolveCursors((Map)value, recursive);
            }
            resolved.put(entry.getKey(), value);
        }
        return resolved;
    }

    private static Object resolveCursorProvider(Object value, StreamingHelper streamingHelper) {
        if (value instanceof TypedValue) {
            TypedValue typedValue = (TypedValue)value;
            Object newValue = streamingHelper.resolveCursorProvider(typedValue.getValue());
            return new TypedValue(newValue, typedValue.getDataType());
        }
        return streamingHelper.resolveCursorProvider(value);
    }

    public static class Builder {
        private Optional<QueryResolver<ParameterizedStatementDefinition>> queryResolverOptional = Optional.empty();
        private Optional<ParameterizedQueryResolver<StoredProcedureCall>> storedProcedureResolverOptional = Optional.empty();
        private Optional<ConfigurableStatementFactory> statementFactoryOptional = Optional.empty();
        private Optional<BiFunction<DbConnection, Charset, RowHandler>> selectRowHandlerOptional = Optional.empty();
        private Optional<BiFunction<DbConnection, Charset, RowHandler>> querySingleRowHandlerOptional = Optional.empty();
        private Optional<BiFunction<DbConnection, Charset, RowHandler>> storedProcedureRowHandlerOptional = Optional.empty();
        private Optional<BiFunction<ConfigurableStatementFactory, ResultSetHandler, QueryExecutor>> selectQueryExecutorOptional = Optional.empty();
        private Optional<BiFunction<ConfigurableStatementFactory, ResultSetHandler, QueryExecutor>> querySingleQueryExecutorOptional = Optional.empty();
        private Optional<Function<ConfigurableStatementFactory, QueryExecutor>> updateExecutorOptional = Optional.empty();

        public Builder withQueryResolver(QueryResolver<ParameterizedStatementDefinition> queryResolver) {
            this.queryResolverOptional = Optional.of(queryResolver);
            return this;
        }

        public Builder withStoredProcedureQueryResolver(ParameterizedQueryResolver<StoredProcedureCall> storedProcedureQueryResolver) {
            this.storedProcedureResolverOptional = Optional.of(storedProcedureQueryResolver);
            return this;
        }

        public Builder withStatementFactory(ConfigurableStatementFactory statementFactory) {
            this.statementFactoryOptional = Optional.of(statementFactory);
            return this;
        }

        public Builder withSelectRowHandler(BiFunction<DbConnection, Charset, RowHandler> selectRowHandler) {
            this.selectRowHandlerOptional = Optional.of(selectRowHandler);
            return this;
        }

        public Builder withQuerySingleRowHandler(BiFunction<DbConnection, Charset, RowHandler> querySingleRowHandler) {
            this.querySingleRowHandlerOptional = Optional.of(querySingleRowHandler);
            return this;
        }

        public Builder withStoredProcedureRowHandler(BiFunction<DbConnection, Charset, RowHandler> storedProcedureRowHandler) {
            this.storedProcedureRowHandlerOptional = Optional.of(storedProcedureRowHandler);
            return this;
        }

        public Builder withSelectQueryExecutor(BiFunction<ConfigurableStatementFactory, ResultSetHandler, QueryExecutor> selectQueryExecutor) {
            this.selectQueryExecutorOptional = Optional.of(selectQueryExecutor);
            return this;
        }

        public Builder withQuerySingleQueryExecutor(BiFunction<ConfigurableStatementFactory, ResultSetHandler, QueryExecutor> querySingleQueryExecutor) {
            this.querySingleQueryExecutorOptional = Optional.of(querySingleQueryExecutor);
            return this;
        }

        public Builder withUpdateExecutor(Function<ConfigurableStatementFactory, QueryExecutor> updateExecutor) {
            this.updateExecutorOptional = Optional.of(updateExecutor);
            return this;
        }

        public DmlOperations build() {
            return new DmlOperations(this.queryResolverOptional.orElse(BaseDbOperations.getDefaultQueryResolver()), this.statementFactoryOptional.orElse(BaseDbOperations.getDefaultStatementFactory()), this.storedProcedureResolverOptional.orElse(DmlOperations.getDefaultStoredProcedureResolver()), this.selectRowHandlerOptional.orElse(DmlOperations.getDefaultInsensitiveMapRowHandler()), this.querySingleRowHandlerOptional.orElse(DmlOperations.getDefaultNonStreamingInsensitiveMapRowHandler()), this.storedProcedureRowHandlerOptional.orElse(DmlOperations.getDefaultInsensitiveMapRowHandler()), this.selectQueryExecutorOptional.orElse(DmlOperations.getDefaultSelectExecutor()), this.querySingleQueryExecutorOptional.orElse(DmlOperations.getDefaultSelectExecutor()), this.updateExecutorOptional.orElse(BaseDbOperations.getDefaultUpdateExecutor()));
        }
    }

    private static class ResultSetCloserExceptionConsumer
    implements Consumer<Exception> {
        private final ResultSetCloserRunnable resultSetCloserRunnable;
        private final String sql;

        private ResultSetCloserExceptionConsumer(StatementStreamingResultSetCloser resultSetCloser, String sql) {
            this.resultSetCloserRunnable = new ResultSetCloserRunnable(resultSetCloser);
            this.sql = sql;
        }

        @Override
        public void accept(Exception e) {
            block2: {
                try {
                    this.resultSetCloserRunnable.run();
                }
                catch (Exception t) {
                    if (!LOGGER.isWarnEnabled()) break block2;
                    LOGGER.warn(String.format("Exception was found closing connection for select operation: %s. Error was: %s", this.sql, t.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private static class ResultSetCloserRunnable
    implements Runnable {
        private final StatementStreamingResultSetCloser resultSetCloser;

        public ResultSetCloserRunnable(StatementStreamingResultSetCloser resultSetCloser) {
            this.resultSetCloser = resultSetCloser;
        }

        @Override
        public void run() {
            this.resultSetCloser.closeResultSets();
        }
    }
}

