/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.query;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.db.commons.api.param.ParameterizedStatementDefinition;
import org.mule.db.commons.internal.domain.query.QueryParamValue;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.resolver.query.AbstractQueryResolver;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class ParameterizedQueryResolver<T extends ParameterizedStatementDefinition<?>>
extends AbstractQueryResolver<T> {
    @Override
    protected List<QueryParamValue> resolveParams(T statementDefinition, QueryTemplate template, StreamingHelper streamingHelper) {
        return template.getInputParams().stream().map(p -> {
            String parameterName = p.getName();
            Optional<Reference<Object>> parameterValue = this.getStreamingAwareParameter(statementDefinition, parameterName, streamingHelper);
            if (parameterValue.isPresent()) {
                return new QueryParamValue(parameterName, parameterValue.get().get());
            }
            throw new IllegalArgumentException(String.format("Parameter '%s' was not bound for query '%s'", parameterName, statementDefinition.getSql()));
        }).collect(Collectors.toList());
    }

    private Optional<Reference<Object>> getStreamingAwareParameter(T statementDefinition, String parameterName, StreamingHelper streamingHelper) {
        return this.getInputParameter(statementDefinition, parameterName).map(ref -> streamingHelper != null ? new Reference(streamingHelper.resolveCursor(ref.get())) : ref);
    }

    protected Optional<Reference<Object>> getInputParameter(T statementDefinition, String parameterName) {
        return ((ParameterizedStatementDefinition)statementDefinition).getInputParameter(parameterName);
    }
}

