/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection.generic;

import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.mule.db.commons.api.config.DbPoolingProfile;
import org.mule.db.commons.api.param.ColumnType;
import org.mule.db.commons.internal.domain.connection.DataSourceConfig;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.connection.DbConnectionProvider;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;

public class GenericConnectionProvider
implements ConnectionProvider<DbConnection>,
Initialisable,
Disposable {
    private DbConnectionProvider dbConnectionProvider;
    private final String configName;
    private final Registry registry;
    private final DbPoolingProfile poolingProfile;
    private final List<? extends ColumnType> columnTypes;
    private final DataSourceConfig connectionParameters;

    public GenericConnectionProvider(String configName, Registry registry, DbPoolingProfile poolingProfile, List<? extends ColumnType> columnTypes, DataSourceConfig connectionParameters) {
        this.configName = configName;
        this.registry = registry;
        this.poolingProfile = poolingProfile;
        this.columnTypes = columnTypes;
        this.connectionParameters = connectionParameters;
    }

    public void initialise() throws InitialisationException {
        this.dbConnectionProvider = new DbConnectionProvider(this.configName, this.registry, this.poolingProfile, this.columnTypes){

            @Override
            public Optional<DataSource> getDataSource() {
                return Optional.empty();
            }

            @Override
            public Optional<DataSourceConfig> getDataSourceConfig() {
                return Optional.ofNullable(GenericConnectionProvider.this.connectionParameters);
            }
        };
        this.dbConnectionProvider.initialise();
    }

    public void dispose() {
        this.dbConnectionProvider.dispose();
    }

    public DbConnection connect() throws ConnectionException {
        return this.dbConnectionProvider.connect();
    }

    public void disconnect(DbConnection dbConnection) {
        this.dbConnectionProvider.disconnect(dbConnection);
    }

    public ConnectionValidationResult validate(DbConnection dbConnection) {
        return this.dbConnectionProvider.validate(dbConnection);
    }
}

