/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.db.commons.internal.domain.logger;

import org.mule.db.commons.internal.domain.param.InputQueryParam;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.slf4j.Logger;

/**
 * Logs a single query in debug level
 */
public class DebugSingleQueryLogger extends AbstractDebugQueryLogger implements SingleQueryLogger {

  private final QueryTemplate queryTemplate;

  public DebugSingleQueryLogger(Logger logger, QueryTemplate queryTemplate) {
    super(logger);

    this.queryTemplate = queryTemplate;

    builder.append("Executing query:\n").append(queryTemplate.getSqlText());

    if (hasParameters()) {
      builder.append("\nParameters:");
    }
  }

  protected boolean hasParameters() {
    return queryTemplate.getInputParams().isEmpty();
  }

  @Override
  public void addParameter(InputQueryParam param, Object value) {
    builder.append("\n")
        .append(param.getName() != null ? param.getName() : param.getIndex())
        .append(" = ").append(value);
  }
}
