/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.executor;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.executor.AbstractExecutor;
import org.mule.db.commons.internal.domain.executor.QueryExecutor;
import org.mule.db.commons.internal.domain.logger.SingleQueryLogger;
import org.mule.db.commons.internal.domain.query.Query;
import org.mule.db.commons.internal.domain.statement.StatementFactory;

public abstract class AbstractSingleQueryExecutor
extends AbstractExecutor
implements QueryExecutor {
    public AbstractSingleQueryExecutor(StatementFactory statementFactory) {
        super(statementFactory);
    }

    @Override
    public final Object execute(DbConnection connection, Query query) throws SQLException {
        Statement statement = this.statementFactory.create(connection, query.getQueryTemplate());
        return this.safely(statement, () -> {
            this.prepareQuery(statement, query, connection);
            return this.doExecuteQuery(connection, statement, query);
        });
    }

    @Override
    public final Object execute(DbConnection connection, Query query, AutoGenerateKeysStrategy autoGenerateKeysStrategy) throws SQLException {
        Statement statement = this.statementFactory.create(connection, query.getQueryTemplate(), autoGenerateKeysStrategy);
        return this.safely(statement, () -> {
            this.prepareQuery(statement, query, connection);
            return this.doExecuteQuery(connection, statement, query, autoGenerateKeysStrategy);
        });
    }

    protected abstract Object doExecuteQuery(DbConnection var1, Statement var2, Query var3) throws SQLException;

    protected abstract Object doExecuteQuery(DbConnection var1, Statement var2, Query var3, AutoGenerateKeysStrategy var4) throws SQLException;

    protected void prepareQuery(Statement statement, Query query, DbConnection connection) throws SQLException {
        SingleQueryLogger queryLogger = this.queryLoggerFactory.createQueryLogger(LOGGER, query.getQueryTemplate());
        if (statement instanceof PreparedStatement) {
            this.doProcessParameters((PreparedStatement)statement, query.getQueryTemplate(), query.getParamValues(), queryLogger, connection);
        }
        queryLogger.logQuery();
    }

    private Object safely(Statement statement, SQLDelegate delegate) throws SQLException {
        try {
            return delegate.run();
        }
        catch (SQLException e) {
            block5: {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("An SQLException exception has occurred.", (Throwable)e);
                }
                try {
                    statement.close();
                }
                catch (SQLException e2) {
                    if (!LOGGER.isWarnEnabled()) break block5;
                    LOGGER.warn("Could not close statement", (Throwable)e2);
                }
            }
            throw e;
        }
    }

    @FunctionalInterface
    private static interface SQLDelegate {
        public Object run() throws SQLException;
    }
}

