/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.exception;

import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import org.mule.db.commons.api.exception.connection.BadSqlSyntaxException;
import org.mule.db.commons.api.exception.connection.QueryExecutionException;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;

public class DbExceptionHandler
extends ExceptionHandler {
    public Exception enrichException(Exception e) {
        if (e instanceof ModuleException) {
            return e;
        }
        return this.getCauseOfType(e, SQLSyntaxErrorException.class).map(cause -> new BadSqlSyntaxException(e.getMessage(), e)).orElseGet(() -> this.getCauseOfType(e, SQLException.class).map(sqlException -> {
            if (this.isConnectionException((SQLException)sqlException) || e instanceof ConnectionException) {
                return new ConnectionException(sqlException.getMessage(), (Throwable)sqlException);
            }
            if (this.isBadSyntaxException((SQLException)sqlException)) {
                return new BadSqlSyntaxException(sqlException.getMessage(), (Throwable)sqlException);
            }
            return new QueryExecutionException(sqlException.getMessage(), (Throwable)sqlException);
        }).orElse(e));
    }

    private boolean isConnectionException(SQLException e) {
        String sqlState = e.getSQLState();
        return "08S01".equals(sqlState) || "08001".equals(sqlState);
    }

    private boolean isBadSyntaxException(SQLException e) {
        String sqlState = e.getSQLState();
        return "S0001".equals(sqlState);
    }
}

