/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.sql.DataSource;
import org.mule.db.commons.api.exception.connection.ConnectionCreationException;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.MappedStructResolvedDbType;
import org.mule.db.commons.internal.util.CredentialsMaskUtils;

public class JdbcConnectionFactory {
    private final Function<String, String> maskCredentialsFunction;

    protected JdbcConnectionFactory(Builder builder) {
        this.maskCredentialsFunction = (Function)builder.maskCredentialsFunctionOptional.get();
    }

    public Connection createConnection(DataSource dataSource, List<DbType> customDataTypes) throws SQLException, ConnectionCreationException {
        try {
            Connection connection = dataSource.getConnection();
            if (connection == null) {
                throw new ConnectionCreationException("Unable to create connection to the provided dataSource: " + dataSource);
            }
            Map<String, Class<?>> typeMapping = this.createTypeMapping(customDataTypes);
            if (typeMapping != null && !typeMapping.isEmpty()) {
                connection.setTypeMap(typeMapping);
            }
            return connection;
        }
        catch (SQLException e) {
            String s = this.maskCredentialsFunction.apply(e.getMessage());
            throw new SQLException(s, e.getSQLState(), e.getErrorCode(), e.getCause());
        }
    }

    private Map<String, Class<?>> createTypeMapping(List<DbType> customDataTypes) {
        HashMap typeMapping = new HashMap();
        customDataTypes.stream().filter(dbType -> dbType instanceof MappedStructResolvedDbType).forEach(dbType -> {
            MappedStructResolvedDbType structDbType = (MappedStructResolvedDbType)dbType;
            if (structDbType.getMappedClass() != null) {
                typeMapping.put(structDbType.getName(), structDbType.getMappedClass());
            }
        });
        return typeMapping;
    }

    public static class Builder {
        private Optional<Function<String, String>> maskCredentialsFunctionOptional = Optional.empty();

        public Builder withMaskCredentialsFunction(Function<String, String> maskCredentialsFunction) {
            this.maskCredentialsFunctionOptional = Optional.of(maskCredentialsFunction);
            return this;
        }

        public JdbcConnectionFactory build() {
            if (!this.maskCredentialsFunctionOptional.isPresent()) {
                this.maskCredentialsFunctionOptional = Optional.of(CredentialsMaskUtils::maskUrlUserAndPassword);
            }
            return new JdbcConnectionFactory(this);
        }
    }
}

