/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.exception;

import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import org.mule.db.commons.api.exception.connection.BadSqlSyntaxException;
import org.mule.db.commons.api.exception.connection.QueryExecutionException;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbExceptionHandler
extends ExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbExceptionHandler.class);

    public Exception enrichException(Exception e) {
        if (e instanceof ModuleException) {
            return e;
        }
        return this.getCauseOfType(e, SQLSyntaxErrorException.class).map(cause -> new BadSqlSyntaxException(e.getMessage(), e)).orElseGet(() -> this.getCauseOfType(e, SQLException.class).map(sqlException -> {
            String sqlState = sqlException.getSQLState();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SQLState is: {}, ErrorCode is: {}, Cause is: {}", new Object[]{sqlState, sqlException.getErrorCode(), sqlException.getCause()});
            }
            if (e instanceof ConnectionException || this.isConnectionException(sqlState)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Exception is related to the Connection. Throwing ConnectionException. Exception: {}", (Object)sqlException.getMessage());
                }
                return new ConnectionException(sqlException.getMessage(), (Throwable)sqlException);
            }
            if (this.isBadSyntaxException(sqlState)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Exception is related to the sql' syntax. Throwing BadSqlSyntaxException. Exception: {}", (Object)sqlException.getMessage());
                }
                return new BadSqlSyntaxException(sqlException.getMessage(), (Throwable)sqlException);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Defaulting to QueryExecutionException. Exception: {}", (Object)sqlException.getMessage());
            }
            return new QueryExecutionException(sqlException.getMessage(), (Throwable)sqlException);
        }).orElse(e));
    }

    private boolean isConnectionException(String sqlState) {
        switch (sqlState == null ? "" : sqlState) {
            case "08000": 
            case "08001": 
            case "08S01": 
            case "08002": 
            case "08003": 
            case "08004": 
            case "08006": {
                return true;
            }
        }
        return false;
    }

    private boolean isBadSyntaxException(String sqlState) {
        return "S0001".equals(sqlState);
    }
}

