/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import org.apache.commons.lang3.StringUtils;
import org.mule.db.commons.api.config.DbPoolingProfile;
import org.mule.db.commons.api.exception.connection.ConnectionClosingException;
import org.mule.db.commons.api.exception.connection.ConnectionCommitException;
import org.mule.db.commons.api.exception.connection.ConnectionCreationException;
import org.mule.db.commons.api.exception.connection.DbError;
import org.mule.db.commons.api.param.ColumnType;
import org.mule.db.commons.internal.domain.connection.DataSourceConfig;
import org.mule.db.commons.internal.domain.connection.DataSourceFactory;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.connection.DefaultDbConnection;
import org.mule.db.commons.internal.domain.connection.JdbcConnectionFactory;
import org.mule.db.commons.internal.domain.type.ArrayResolvedDbType;
import org.mule.db.commons.internal.domain.type.ClobResolvedDataType;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.MappedStructResolvedDbType;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;
import org.mule.db.commons.internal.domain.type.StructDbType;
import org.mule.db.commons.internal.domain.xa.XADbConnection;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tx.DataSourceDecorator;
import org.mule.runtime.api.tx.MuleXaObject;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbConnectionProvider
implements ConnectionProvider<DbConnection>,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbConnectionProvider.class);
    public static final String DRIVER_FILE_NAME_PATTERN = "(.*)\\.jar";
    private static final String CONNECTION_ERROR_MESSAGE = "Could not obtain connection from data source";
    private static final String ERROR_TRYING_TO_LOAD_DRIVER = "Error trying to load driver";
    @RefName
    private String configName;
    @Inject
    private Registry registry;
    private DataSource dataSource;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced")
    private DbPoolingProfile poolingProfile;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced")
    private List<? extends ColumnType> columnTypes = Collections.emptyList();
    private DataSourceFactory dataSourceFactory;
    private List<DbType> resolvedCustomTypes = Collections.emptyList();
    private final JdbcConnectionFactory jdbcConnectionFactory = this.createJdbcConnectionFactory();

    protected JdbcConnectionFactory createJdbcConnectionFactory() {
        return new JdbcConnectionFactory.Builder().build();
    }

    private Optional<DbError> getDbErrorType(Throwable t) {
        if (!(t instanceof SQLException)) {
            return Optional.empty();
        }
        SQLException e = (SQLException)t;
        String message = e.getMessage();
        if (message.contains(ERROR_TRYING_TO_LOAD_DRIVER)) {
            return Optional.of(DbError.CANNOT_LOAD_DRIVER);
        }
        return this.getDbVendorErrorType(e);
    }

    protected Optional<DbError> getDbVendorErrorType(SQLException e) {
        return Optional.empty();
    }

    public final DbConnection connect() throws ConnectionException {
        try {
            Connection jdbcConnection = this.jdbcConnectionFactory.createConnection(this.dataSource, this.resolvedCustomTypes);
            Optional<XAConnection> optionalXaConnection = this.getXaConnection(jdbcConnection);
            DbConnection connection = this.createDbConnection(jdbcConnection);
            if (optionalXaConnection.isPresent()) {
                connection = new XADbConnection(connection, optionalXaConnection.get());
            }
            return connection;
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.handleSQLConnectionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect(DbConnection connection) {
        Connection jdbcConnection = connection.getJdbcConnection();
        try {
            if (jdbcConnection.isClosed()) {
                return;
            }
        }
        catch (SQLException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error checking for closed connection while trying to disconnect", (Throwable)e);
            }
            return;
        }
        RuntimeException exception = null;
        try {
            if (!jdbcConnection.getAutoCommit()) {
                jdbcConnection.commit();
            }
        }
        catch (SQLException e) {
            exception = new ConnectionCommitException(e);
        }
        finally {
            block18: {
                try {
                    connection.release();
                }
                catch (Exception e) {
                    if (exception != null) break block18;
                    exception = new ConnectionClosingException(e);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public ConnectionValidationResult validate(DbConnection connection) {
        return ConnectionValidationResult.success();
    }

    public void initialise() throws InitialisationException {
        this.dataSourceFactory = this.createDataSourceFactory();
        try {
            this.dataSource = this.obtainDataSource();
        }
        catch (SQLException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)("Could not create DataSource for DB config " + this.configName)), (Throwable)e, (Initialisable)this);
        }
        this.resolvedCustomTypes = this.resolveCustomTypes();
    }

    public final void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.dataSourceFactory, (Logger)LOGGER);
    }

    public abstract Optional<DataSource> getDataSource();

    public abstract Optional<DataSourceConfig> getDataSourceConfig();

    protected DbConnection createDbConnection(Connection connection) throws Exception {
        return new DefaultDbConnection(connection, this.resolvedCustomTypes);
    }

    private DataSource obtainDataSource() throws SQLException {
        DataSource dataSource;
        Optional<DataSource> optionalDataSource = this.getDataSource();
        if (optionalDataSource.isPresent()) {
            dataSource = optionalDataSource.get();
        } else {
            DataSourceConfig dataSourceConfig = this.getDataSourceConfig().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create DataSource for DB config, no DataSource or DataSourceConfig has been provided " + this.configName))));
            dataSource = this.createDataSource(dataSourceConfig);
        }
        return this.dataSourceFactory.decorateDataSource(dataSource, this.poolingProfile);
    }

    private DataSource createDataSource(DataSourceConfig dataSourceConfig) throws SQLException {
        return this.dataSourceFactory.create(dataSourceConfig, this.poolingProfile);
    }

    public List<DbType> resolveCustomTypes() {
        return (List)this.columnTypes.stream().map(type -> {
            String name = type.getTypeName();
            int id = type.getId();
            if (id == 2003) {
                return new ArrayResolvedDbType(id, name);
            }
            if (id == 2002) {
                String className = type.getClassName();
                if (!StringUtils.isEmpty((CharSequence)className)) {
                    Class<?> mappedClass;
                    try {
                        mappedClass = Class.forName(className);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Cannot find mapped class: " + className);
                    }
                    return new MappedStructResolvedDbType(id, name, mappedClass);
                }
                return new StructDbType(id, name);
            }
            if (id == 2005) {
                return new ClobResolvedDataType(id, name);
            }
            return new ResolvedDbType(id, name);
        }).collect(Collectors.toImmutableList());
    }

    private DataSourceFactory createDataSourceFactory() {
        return new DataSourceFactory(this.configName + System.identityHashCode(this), this.registry.lookupAllByType(DataSourceDecorator.class));
    }

    public DataSource getConfiguredDataSource() {
        return this.dataSource;
    }

    private boolean isXaConnection(Connection jdbcConnection) {
        return jdbcConnection instanceof MuleXaObject && ((MuleXaObject)jdbcConnection).getTargetObject() instanceof XAConnection;
    }

    private Optional<XAConnection> getXaConnection(Connection jdbcConnection) {
        return this.isXaConnection(jdbcConnection) ? Optional.of((XAConnection)((MuleXaObject)jdbcConnection).getTargetObject()) : Optional.empty();
    }

    private ConnectionException handleSQLConnectionException(Exception e) {
        Optional<DbError> dbError = Optional.empty();
        HashSet<Exception> causes = new HashSet<Exception>();
        Throwable t = e;
        while (t != null && causes.add((Exception)t)) {
            dbError = this.getDbErrorType(t);
            if (dbError.isPresent()) continue;
            t = t.getCause();
        }
        return dbError.map(errorType -> new ConnectionCreationException(CONNECTION_ERROR_MESSAGE, e, (DbError)((Object)errorType))).orElse(new ConnectionCreationException(CONNECTION_ERROR_MESSAGE, e, DbError.CONNECTIVITY));
    }
}

