/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.db.commons.internal.result.statement;

import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

/**
 * Processes {@link Statement} results creating a map containing them.
 */
public abstract class AbstractMapStatementResultHandler implements StatementResultHandler {

  private final ResultSetHandler resultSetHandler;

  public AbstractMapStatementResultHandler(ResultSetHandler resultSetHandler) {
    this.resultSetHandler = resultSetHandler;
  }

  @Override
  public Map<String, Object> processStatement(DbConnection connection, Statement statement, QueryTemplate queryTemplate,
                                              AutoGenerateKeysStrategy autoGenerateKeysStrategy)
      throws SQLException {
    Map<String, Object> result = createResultMap();

    StatementResultIteratorFactory statementResultIteratorFactory =
        connection.getStatementResultIteratorFactory(resultSetHandler);
    StatementResultIterator statementResultIterator =
        statementResultIteratorFactory.create(connection, statement, queryTemplate, autoGenerateKeysStrategy);


    while (statementResultIterator.hasNext()) {
      SingleStatementResult next = statementResultIterator.next();

      result.put(next.getName(), next.getResult());
    }

    return result;
  }

  protected abstract Map<String, Object> createResultMap();
}
