package org.mule.db.commons.internal.domain.connection.enhydra.wrappers;

import org.enhydra.jdbc.standard.StandardDataSource;
import org.mule.runtime.api.tls.TlsContextFactory;

import java.sql.Connection;
import java.sql.SQLException;

import static org.mule.db.commons.internal.domain.connection.enhydra.wrappers.EnhydraWrapperUtils.getSecureConnectionIfPossible;

/**
 * Wrapper class for Enhydra' {@link StandardDataSource} to modify its behaviour.
 *
 * @since 1.3.0
 */
public class StandardDataSourceWrapper extends StandardDataSource {

  private final transient TlsContextFactory tlsContextFactory;

  public StandardDataSourceWrapper(TlsContextFactory tlsContextFactory) {
    super();
    this.tlsContextFactory = tlsContextFactory;
  }

  @Override
  synchronized public Connection getConnection(String user, String password) throws SQLException {
    return getSecureConnectionIfPossible(user, password, this, this.tlsContextFactory);
  }

}
