/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.metadata;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.metadata.BaseDbMetadataResolver;
import org.mule.db.commons.internal.domain.param.InputQueryParam;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.parser.SimpleQueryTemplateParser;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;

public class DbInputMetadataResolver
extends BaseDbMetadataResolver
implements InputTypeResolver<String> {
    public String getCategoryName() {
        return "DbCategory";
    }

    public MetadataType getInputMetadata(MetadataContext context, String query) throws MetadataResolvingException, ConnectionException {
        this.typeLoader = context.getTypeLoader();
        this.typeBuilder = context.getTypeBuilder();
        QueryTemplate queryTemplate = this.parseQuery(query);
        List<InputQueryParam> inputParams = queryTemplate.getInputParams();
        if (inputParams.isEmpty()) {
            return this.typeBuilder.nullType().build();
        }
        PreparedStatement statement = this.getStatement(context, queryTemplate);
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (InputQueryParam inputParam : inputParams) {
            String name = inputParam.getName();
            if (name == null) {
                return this.typeBuilder.anyType().build();
            }
            fieldNames.add(name);
        }
        try {
            return this.getInputMetadataUsingStatementMetadata(statement, fieldNames);
        }
        catch (SQLException e) {
            return this.getStaticInputMetadata(fieldNames);
        }
    }

    @Override
    protected QueryTemplate parseQuery(String query) {
        return new SimpleQueryTemplateParser().parse(query);
    }

    @Override
    protected PreparedStatement getStatement(MetadataContext context, QueryTemplate query) throws ConnectionException, MetadataResolvingException {
        PreparedStatement statement;
        DbConnection connection = (DbConnection)context.getConnection().orElseThrow(() -> new MetadataResolvingException("A connection is required to resolve Metadata but none was provided", FailureCode.INVALID_CONFIGURATION));
        try {
            statement = connection.getJdbcConnection().prepareStatement(query.getSqlText());
        }
        catch (SQLException e) {
            throw new MetadataResolvingException(e.getMessage(), FailureCode.UNKNOWN, (Throwable)e);
        }
        return statement;
    }

    private MetadataType getStaticInputMetadata(List<String> fieldNames) {
        HashMap<String, MetadataType> recordModels = new HashMap<String, MetadataType>();
        for (String fieldName : fieldNames) {
            recordModels.put(fieldName, this.getDataTypeMetadataModel(12));
        }
        ObjectTypeBuilder record = this.typeBuilder.objectType();
        recordModels.entrySet().forEach(e -> record.addField().key((String)e.getKey()).value((MetadataType)e.getValue()));
        return record.build();
    }

    private MetadataType getInputMetadataUsingStatementMetadata(PreparedStatement statement, List<String> fieldNames) throws SQLException {
        ParameterMetaData parameterMetaData = statement.getParameterMetaData();
        HashMap recordModels = new HashMap();
        int i = 1;
        ObjectTypeBuilder record = this.typeBuilder.objectType();
        for (String fieldName : fieldNames) {
            int dataType = parameterMetaData.getParameterType(i);
            ObjectFieldTypeBuilder fieldTypeBuilder = record.addField();
            fieldTypeBuilder.key(fieldName);
            try {
                fieldTypeBuilder.value(this.getDataTypeMetadataModel(dataType, parameterMetaData.getParameterClassName(i)));
            }
            catch (Exception e2) {
                fieldTypeBuilder.value((MetadataType)this.typeBuilder.anyType().build());
            }
            try {
                int nullableCode = parameterMetaData.isNullable(i);
                if (nullableCode == 0) {
                    fieldTypeBuilder.required();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        recordModels.entrySet().forEach(e -> record.addField().key((String)e.getKey()).value((MetadataType)e.getValue()));
        return record.build();
    }
}

