/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.AbstractStructuredDbType;

public class ArrayResolvedDbType
extends AbstractStructuredDbType {
    public ArrayResolvedDbType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value, DbConnection dbConnection) throws SQLException {
        if (!(value instanceof Array)) {
            if (value instanceof Object[]) {
                value = dbConnection.createArrayOf(this.name, (Object[])value);
            } else if (value instanceof List) {
                value = dbConnection.createArrayOf(this.name, ((List)value).toArray());
            } else {
                throw new IllegalArgumentException(ArrayResolvedDbType.createUnsupportedTypeErrorMessage(value));
            }
        }
        statement.setArray(index, (Array)value);
    }

    @Override
    public Object getParameterValue(CallableStatement statement, int index) throws SQLException {
        Object array;
        Object object = array = statement.getArray(index) != null ? statement.getArray(index).getArray() : null;
        if (array instanceof Collection) {
            return ((Collection)array).stream().map(this::processArray).collect(Collectors.toList());
        }
        if (array instanceof Object[]) {
            return Arrays.stream((Object[])array).map(this::processArray).collect(Collectors.toList());
        }
        return array;
    }

    private Object processArray(Object object) {
        if (object instanceof Struct) {
            try {
                return ((Struct)object).getAttributes();
            }
            catch (SQLException e1) {
                throw new RuntimeException(e1);
            }
        }
        return object;
    }

    public static String createUnsupportedTypeErrorMessage(Object value) {
        return String.format("Cannot create a %s from a value of type %s", Struct.class.getName(), value.getClass());
    }
}

