/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.row;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import org.apache.commons.io.input.ReaderInputStream;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.result.row.InsensitiveMapRowHandler;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.IOUtils;

public class NonStreamingInsensitiveMapRowHandler
extends InsensitiveMapRowHandler {
    public NonStreamingInsensitiveMapRowHandler(DbConnection dbConnection) {
        super(dbConnection);
    }

    public NonStreamingInsensitiveMapRowHandler(DbConnection dbConnection, Charset charset) {
        super(dbConnection, charset);
    }

    @Override
    protected TypedValue<Object> handleSqlXmlType(SQLXML value) throws SQLException {
        return new TypedValue((Object)value.getString(), DataType.builder().type(SQLXML.class).mediaType(MediaType.XML).build());
    }

    @Override
    protected TypedValue<Object> handleBlobType(Blob value) throws SQLException {
        ByteArrayInputStream is = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)value.getBinaryStream()));
        return new TypedValue((Object)IOUtils.toByteArray((InputStream)is), DataType.builder().type(byte[].class).mediaType(MediaType.BINARY).build());
    }

    @Override
    protected TypedValue<Object> handleClobType(Clob value) throws SQLException {
        ReaderInputStream inputStream = new ReaderInputStream(value.getCharacterStream(), this.charset);
        return new TypedValue((Object)IOUtils.toString((InputStream)inputStream), DataType.builder().type(String.class).mediaType(MediaType.TEXT).charset(this.charset).build());
    }
}

