/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClobResolvedDataType
extends ResolvedDbType {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClobResolvedDataType.class);
    private static final String JTDS_DRIVER = "jTDS";

    public ClobResolvedDataType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value, DbConnection connection) throws SQLException {
        block11: {
            if (value != null && !(value instanceof Clob)) {
                String valueString;
                if (value instanceof String) {
                    valueString = (String)value;
                } else if (value instanceof InputStream) {
                    try {
                        valueString = IOUtils.toString((InputStream)((InputStream)value));
                    }
                    catch (IOException e) {
                        throw new SQLException("Error converting Stream to String to set CLOB object", e);
                    }
                } else {
                    throw new IllegalArgumentException(ClobResolvedDataType.createUnsupportedTypeErrorMessage(value));
                }
                try {
                    LOGGER.debug("Creating CLOB object");
                    Clob clob = statement.getConnection().createClob();
                    clob.setString(1L, valueString);
                    super.setParameterValue(statement, index, clob, connection);
                }
                catch (Throwable t) {
                    LOGGER.debug("Error creating CLOB object. Using alternative way to set CLOB object", t);
                    DatabaseMetaData metaData = statement.getConnection().getMetaData();
                    if (metaData != null && metaData.getDriverName() != null && metaData.getDriverName().contains(JTDS_DRIVER)) {
                        statement.setString(index, valueString);
                        break block11;
                    }
                    statement.setCharacterStream(index, (Reader)new StringReader(valueString), valueString.length());
                }
            } else {
                super.setParameterValue(statement, index, value, connection);
            }
        }
    }

    public static String createUnsupportedTypeErrorMessage(Object value) {
        return String.format("Cannot create a Clob from a value of type '%s'", value.getClass());
    }
}

