/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.db.commons.internal.domain.type;

import org.mule.db.commons.api.DbAggregate;
import org.mule.db.commons.internal.domain.connection.DbConnection;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.List;

/**
 * Defines a structured data type
 */
public class StructDbType extends AbstractStructuredDbType {

  /**
   * Creates a new DB type
   *
   * @param id   type identifier from {#link java.sql.Types} or any custom value.
   * @param name name of the structured type. Non empty.
   */
  public StructDbType(int id, String name) {
    super(id, name);
  }

  @Override
  public void setParameterValue(PreparedStatement statement, int index, Object value, DbConnection dbConnection)
      throws SQLException {
    if (value != null && !(value instanceof Struct)) {
      Connection connection = statement.getConnection();
      if (value instanceof Object[]) {
        value = connection.createStruct(name,
                                        UnknownDbType.createArraysAndStructsInner(Arrays.asList((Object[]) value), dbConnection));
      } else if (value instanceof DbAggregate) {
        value = UnknownDbType.createArraysAndStructs(value, dbConnection);
      } else if (value instanceof List) {
        value = connection.createStruct(name, UnknownDbType.createArraysAndStructsInner((List<?>) value, dbConnection));
      }
    }

    super.setParameterValue(statement, index, value, dbConnection);
  }
}
