/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.xa;

import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.mule.db.commons.api.exception.connection.ConnectionClosingException;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.exception.DbExceptionHandler;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;
import org.mule.db.commons.internal.result.statement.StatementResultIteratorFactory;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XADbConnection
implements DbConnection,
XATransactionalConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(XADbConnection.class);
    private final DbConnection connection;
    private final XAConnection xaConnection;
    private boolean isXaResourceProvided = false;
    private final DbExceptionHandler dbExceptionHandler = new DbExceptionHandler();

    public XADbConnection(DbConnection connection, XAConnection xaConnection) {
        this.connection = connection;
        this.xaConnection = xaConnection;
    }

    public XAResource getXAResource() {
        try {
            XAResource xaResource = this.xaConnection.getXAResource();
            this.isXaResourceProvided = true;
            return xaResource;
        }
        catch (SQLException e) {
            Exception enrichedException = this.dbExceptionHandler.enrichException(e);
            if (enrichedException instanceof ConnectionException) {
                throw new MuleRuntimeException((Throwable)enrichedException);
            }
            throw new MuleRuntimeException((Throwable)new TransactionException(I18nMessageFactory.createStaticMessage((String)"Could not obtain XA Resource"), (Throwable)e));
        }
    }

    public void close() {
        try {
            this.connection.release();
            Connection jdbcConnection = this.connection.getJdbcConnection();
            if (!jdbcConnection.isClosed()) {
                jdbcConnection.close();
            }
        }
        catch (SQLException | ConnectionClosingException e) {
            LOGGER.info("Exception while explicitly closing the xaConnection (some providers require this). The exception will be ignored and only logged: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.isXaResourceProvided = false;
        }
    }

    public void begin() throws TransactionException {
        this.connection.begin();
    }

    public void commit() throws TransactionException {
        this.connection.commit();
    }

    public void rollback() throws TransactionException {
        this.connection.rollback();
    }

    @Override
    public StatementResultIteratorFactory getStatementResultIteratorFactory(ResultSetHandler resultSetHandler) {
        return this.connection.getStatementResultIteratorFactory(resultSetHandler);
    }

    @Override
    public List<DbType> getVendorDataTypes() {
        return this.connection.getVendorDataTypes();
    }

    @Override
    public List<DbType> getCustomDataTypes() {
        return this.connection.getCustomDataTypes();
    }

    @Override
    public Connection getJdbcConnection() {
        return this.connection.getJdbcConnection();
    }

    @Override
    public void release() {
        this.connection.release();
    }

    @Override
    public void beginStreaming() {
        this.connection.beginStreaming();
    }

    @Override
    public boolean isStreaming() {
        return this.connection.isStreaming();
    }

    @Override
    public void endStreaming() {
        this.connection.endStreaming();
    }

    @Override
    public boolean isTransactionActive() {
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (transaction == null) {
            return false;
        }
        if (transaction.isXA() && this.isXaResourceProvided) {
            return TransactionCoordination.isTransactionActive();
        }
        return this.connection.isTransactionActive();
    }

    @Override
    public boolean supportsContentStreaming() {
        return this.connection.supportsContentStreaming();
    }

    @Override
    public void incrementActiveLobStreams() {
        this.connection.incrementActiveLobStreams();
    }

    @Override
    public void decrementActiveLobStreams() {
        this.connection.decrementActiveLobStreams();
    }

    @Override
    public void abortActiveLobStreams() {
        this.connection.abortActiveLobStreams();
    }

    @Override
    public boolean hasActiveLobStreams() {
        return this.connection.hasActiveLobStreams();
    }

    @Override
    public Array createArray(String typeName, Object[] values) throws SQLException {
        return this.connection.createArray(typeName, values);
    }
}

