/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal;

import java.sql.SQLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.api.exception.connection.QueryExecutionException;
import org.mule.db.commons.internal.exception.DbExceptionHandler;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DbExceptionHandlerTestCase
extends AbstractMuleTestCase {
    private DbExceptionHandler handler = new DbExceptionHandler();

    @Test
    public void handleModuleException() {
        ModuleException e = (ModuleException)Mockito.mock(ModuleException.class);
        Assert.assertThat((Object)this.handler.enrichException((Exception)e), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
    }

    @Test
    public void handle08S01SqlState() {
        this.assertConnectivitySqlState("08S01");
    }

    @Test
    public void handle08001SqlState() {
        this.assertConnectivitySqlState("08001");
    }

    @Test
    public void genericSqlException() {
        SQLException sqlException = (SQLException)Mockito.mock(SQLException.class);
        Exception handledException = this.handler.enrichException((Exception)sqlException);
        Assert.assertThat((Object)handledException, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(QueryExecutionException.class)));
        Assert.assertThat((Object)handledException.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)sqlException)));
    }

    @Test
    public void nonSqlException() {
        RuntimeException e = new RuntimeException();
        Assert.assertThat((Object)this.handler.enrichException((Exception)e), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
    }

    private void assertConnectivitySqlState(String sqlState) {
        SQLException sqlException = (SQLException)Mockito.mock(SQLException.class);
        Mockito.when((Object)sqlException.getSQLState()).thenReturn((Object)sqlState);
        Exception handledException = this.handler.enrichException((Exception)sqlException);
        Assert.assertThat((Object)handledException, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ConnectionException.class)));
        Assert.assertThat((Object)handledException.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)sqlException)));
    }
}

