/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.statement;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.DefaultAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;
import org.mule.db.commons.internal.result.statement.StatementResultIterator;
import org.mule.runtime.api.metadata.TypedValue;

public class StatementResultIteratorTestCase {
    @Test
    public void clobsAreFreedWhenRead() throws Exception {
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        QueryTemplate queryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        DefaultAutoGenerateKeysStrategy autoGenerateKeysStrategy = new DefaultAutoGenerateKeysStrategy();
        ResultSetHandler resultSetHandler = (ResultSetHandler)Mockito.mock(ResultSetHandler.class);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Clob clob = (Clob)Mockito.mock(Clob.class);
        Reader clobReader = (Reader)Mockito.mock(Reader.class);
        Mockito.when((Object)connection.supportsContentStreaming()).thenReturn((Object)true);
        Mockito.when((Object)queryTemplate.getOutputParams()).thenReturn(Collections.emptyList());
        Mockito.when((Object)statement.getResultSet()).thenReturn((Object)resultSet);
        Mockito.when((Object)clob.getCharacterStream()).thenReturn((Object)clobReader);
        Mockito.when((Object)clobReader.read((char[])Mockito.any(), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)-1);
        StatementResultIterator resultIterator = new StatementResultIterator(connection, statement, queryTemplate, (AutoGenerateKeysStrategy)autoGenerateKeysStrategy, resultSetHandler);
        Method m = StatementResultIterator.class.getDeclaredMethod("handleClobType", Clob.class);
        m.setAccessible(true);
        TypedValue result = (TypedValue)m.invoke((Object)resultIterator, clob);
        InputStream is = (InputStream)result.getValue();
        is.read();
        ((Clob)Mockito.verify((Object)clob, (VerificationMode)Mockito.times((int)1))).free();
        m.setAccessible(false);
    }
}

