/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.unit;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.DefaultAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;
import org.mule.db.commons.internal.result.statement.StatementResultIterator;

public class StatementResultIteratorTestCase {
    private StatementResultIterator statementResultIterator;

    @Before
    public void beforeTest() throws SQLException {
        DefaultAutoGenerateKeysStrategy autoGenerateKeysStrategy = new DefaultAutoGenerateKeysStrategy();
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData databaseMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)dbConnection.getJdbcConnection()).thenReturn((Object)connection);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)databaseMetaData);
        Mockito.when((Object)databaseMetaData.supportsMultipleOpenResults()).thenReturn((Object)true);
        CallableStatement statement = (CallableStatement)Mockito.mock(CallableStatement.class);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)statement.getResultSet()).thenReturn((Object)resultSet);
        Mockito.when((Object)statement.getGeneratedKeys()).thenReturn(null);
        Mockito.when((Object)statement.getMoreResults(2)).thenReturn((Object)false);
        Mockito.when((Object)statement.getUpdateCount()).thenReturn((Object)-1);
        QueryTemplate queryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        Mockito.when((Object)queryTemplate.getOutputParams()).thenReturn(Collections.emptyList());
        ResultSetHandler resultSetHandler = (ResultSetHandler)Mockito.mock(ResultSetHandler.class);
        Mockito.when((Object)resultSetHandler.processResultSet(dbConnection, resultSet)).thenReturn(null);
        this.statementResultIterator = new StatementResultIterator(dbConnection, (Statement)statement, queryTemplate, (AutoGenerateKeysStrategy)autoGenerateKeysStrategy, resultSetHandler);
    }

    @Test
    public void setStatementResultIteratorHastNextReturnsFalseWhereThereIsNoMoreResultSets() {
        Assert.assertTrue((boolean)this.statementResultIterator.hasNext());
        this.statementResultIterator.next();
        Assert.assertFalse((boolean)this.statementResultIterator.hasNext());
    }
}

