/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.ArrayResolvedDbType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ArrayResolvedDbTypeTestCase
extends AbstractMuleTestCase {
    private static final int PARAM_INDEX = 1;
    private static final String TYPE_NAME = "testStruct";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ArrayResolvedDbType dataType;
    private PreparedStatement statement;
    private DbConnection dbConnection;
    private Array dbArray;

    @Before
    public void setUp() throws Exception {
        this.dataType = new ArrayResolvedDbType(2003, TYPE_NAME);
        this.statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        this.dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        this.dbArray = (Array)Mockito.mock(Array.class);
        Mockito.when((Object)this.statement.getConnection()).thenReturn((Object)connection);
    }

    @Test
    public void convertsJavaArray() throws Exception {
        Object[] value = new Object[]{"foo", "bar"};
        Mockito.when((Object)this.dbConnection.createArray(TYPE_NAME, value)).thenReturn((Object)this.dbArray);
        this.dataType.setParameterValue(this.statement, 1, (Object)value, this.dbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setArray(1, this.dbArray);
    }

    @Test
    public void convertsList() throws Exception {
        ArrayList<String> value = new ArrayList<String>();
        value.add("foo");
        value.add("bar");
        Mockito.when((Object)this.dbConnection.createArray((String)MockitoHamcrest.argThat((Matcher)Matchers.equalTo((Object)TYPE_NAME)), (Object[])MockitoHamcrest.argThat((Matcher)Matchers.arrayContaining((Object[])new String[]{"foo", "bar"})))).thenReturn((Object)this.dbArray);
        this.dataType.setParameterValue(this.statement, 1, value, this.dbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setArray(1, this.dbArray);
    }

    @Test
    public void failsToConvertUnsupportedType() throws Exception {
        Object value = new Object();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)ArrayResolvedDbType.createUnsupportedTypeErrorMessage((Object)value)));
        this.dataType.setParameterValue(this.statement, 1, value, this.dbConnection);
    }

    @Test
    public void getParameterValue_WhenGetArrayIsNull_ThenNoException() throws SQLException {
        CallableStatement callableStatementMock = (CallableStatement)Mockito.mock(CallableStatement.class);
        Object parameterValue = this.dataType.getParameterValue(callableStatementMock, 1);
        Assert.assertNull((Object)parameterValue);
    }
}

