/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;

public class BlobDbType
extends ResolvedDbType {
    public BlobDbType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value, DbConnection connection) throws SQLException {
        value = this.canBeCoercedToBlob(value) ? this.coerceToBlob(statement, index, value) : value;
        super.setParameterValue(statement, index, value, connection);
    }

    private boolean canBeCoercedToBlob(Object value) {
        return value instanceof byte[] || value instanceof InputStream || value instanceof String;
    }

    private Object coerceToBlob(PreparedStatement statement, int index, Object value) throws SQLException {
        Blob blob = statement.getConnection().createBlob();
        blob.setBytes(1L, this.getBlobBytes(value, index));
        return blob;
    }

    private byte[] getBlobBytes(Object value, int index) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof InputStream) {
            try {
                return IOUtils.toByteArray((InputStream)((InputStream)value));
            }
            catch (IOException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not consume inputStream in parameter of index " + index)), (Throwable)e);
            }
        }
        if (value instanceof String) {
            return ((String)value).getBytes();
        }
        throw new IllegalArgumentException(String.format("Object of class '%s' cannot be coerced into a BLOB", value.getClass().getName()));
    }
}

