/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.ClobResolvedDataType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ClobResolvedDataTypeTestCase
extends AbstractMuleTestCase {
    private static final int PARAM_INDEX = 1;
    private static final String TEST_STRING = "Hello World!";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ClobResolvedDataType dataType;
    private PreparedStatement statement;
    private Connection connection;
    private DatabaseMetaData metadata;
    private DbConnection dbConnection;
    private Clob clob;

    @Before
    public void setUp() throws Exception {
        this.dataType = new ClobResolvedDataType(2005, null);
        this.statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.connection = (Connection)Mockito.mock(Connection.class);
        this.metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        this.dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        this.clob = (Clob)Mockito.mock(Clob.class);
        Mockito.when((Object)this.statement.getConnection()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.connection.createClob()).thenReturn((Object)this.clob);
        Mockito.when((Object)this.connection.getMetaData()).thenReturn((Object)this.metadata);
    }

    @Test
    public void convertsStringToClobWhenDriverSupportsSetClob() throws Exception {
        String value = "foo";
        this.dataType.setParameterValue(this.statement, 1, (Object)value, this.dbConnection);
        ((Connection)Mockito.verify((Object)this.connection)).createClob();
    }

    @Test
    public void convertsInputStreamToClobWhenDriverSupportsSetClob() throws Exception {
        String streamContent = "bar";
        StringInputStream value = new StringInputStream(streamContent);
        this.dataType.setParameterValue(this.statement, 1, (Object)value, this.dbConnection);
        ((Connection)Mockito.verify((Object)this.connection)).createClob();
    }

    @Test
    public void convertsStringToClobWhenDriverDoesNotSupportSetClob() throws Exception {
        Mockito.when((Object)this.connection.createClob()).thenThrow(new Throwable[]{new RuntimeException()});
        String value = "foo";
        this.dataType.setParameterValue(this.statement, 1, (Object)value, this.dbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setCharacterStream(ArgumentMatchers.eq((int)1), (Reader)ArgumentMatchers.any(StringReader.class));
    }

    @Test
    public void convertsInputStreamToClobWhenDriverDoesNotSupportSetClob() throws Exception {
        Mockito.when((Object)this.connection.createClob()).thenThrow(new Throwable[]{new RuntimeException()});
        String streamContent = "bar";
        StringInputStream value = new StringInputStream(streamContent);
        this.dataType.setParameterValue(this.statement, 1, (Object)value, this.dbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setCharacterStream(ArgumentMatchers.eq((int)1), (Reader)ArgumentMatchers.any(InputStreamReader.class));
    }

    @Test
    public void setClobDirectly() throws Exception {
        Clob clob = (Clob)Mockito.mock(Clob.class);
        this.dataType.setParameterValue(this.statement, 1, (Object)clob, this.dbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setObject(1, (Object)clob, 2005);
    }

    @Test
    public void failsToConvertUnsupportedType() throws Exception {
        Object value = new Object();
        String expectedExceptionMessage = String.format("Cannot create a Clob from a value of type '%s'", value.getClass());
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)expectedExceptionMessage));
        this.dataType.setParameterValue(this.statement, 1, value, this.dbConnection);
    }

    @Test
    public void setClobWithMoreThan4000CharWithJTDS() throws Exception {
        String value = RandomStringUtils.randomPrint((int)4100);
        Mockito.when((Object)this.metadata.getDriverName()).thenReturn((Object)"jTDS Type 4 JDBC Driver for MS SQL Server and Sybase");
        Mockito.when((Object)this.connection.createClob()).thenThrow(new Throwable[]{new RuntimeException()});
        this.dataType.setParameterValue(this.statement, 1, (Object)value, this.dbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setString(1, value);
    }

    @Test
    public void stringValueJTDSTestCase() throws Exception {
        ClobResolvedDataType crdt = new ClobResolvedDataType(1, "TEST");
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)statement.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)connection.createClob()).thenThrow(RuntimeException.class);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)metadata);
        Mockito.when((Object)metadata.getDriverName()).thenReturn((Object)"jTDS");
        crdt.setParameterValue(statement, 1, (Object)TEST_STRING, dbConnection);
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setString(1, TEST_STRING);
    }

    @Test
    public void inputStreamJTDSTestCase() throws Exception {
        ClobResolvedDataType crdt = new ClobResolvedDataType(1, "TEST");
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        ByteArrayInputStream is = new ByteArrayInputStream(TEST_STRING.getBytes(StandardCharsets.UTF_8));
        Connection connection = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)statement.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)connection.createClob()).thenThrow(RuntimeException.class);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)metadata);
        Mockito.when((Object)metadata.getDriverName()).thenReturn((Object)"jTDS");
        crdt.setParameterValue(statement, 1, (Object)is, dbConnection);
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setString(1, TEST_STRING);
    }

    @Test
    public void stringValueNoJTDSTestCase() throws Exception {
        ClobResolvedDataType crdt = new ClobResolvedDataType(1, "TEST");
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)statement.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)connection.createClob()).thenThrow(RuntimeException.class);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)metadata);
        Mockito.when((Object)metadata.getDriverName()).thenReturn((Object)"myDriver");
        crdt.setParameterValue(statement, 1, (Object)TEST_STRING, dbConnection);
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setCharacterStream(Mockito.anyInt(), (Reader)Mockito.any());
    }

    @Test
    public void inputStreamNoJTDSTestCase() throws Exception {
        ClobResolvedDataType crdt = new ClobResolvedDataType(1, "TEST");
        PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        ByteArrayInputStream is = new ByteArrayInputStream(TEST_STRING.getBytes(StandardCharsets.UTF_8));
        Connection connection = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Reader reader = (Reader)Mockito.mock(Reader.class);
        Mockito.when((Object)statement.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)connection.createClob()).thenThrow(RuntimeException.class);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)metadata);
        Mockito.when((Object)metadata.getDriverName()).thenReturn((Object)"myDriver");
        crdt.setParameterValue(statement, 1, (Object)is, dbConnection);
        ((PreparedStatement)Mockito.verify((Object)statement, (VerificationMode)Mockito.times((int)1))).setCharacterStream(Mockito.anyInt(), (Reader)Mockito.any());
    }

    private static class StringInputStream
    extends ReaderInputStream {
        public StringInputStream(String source) {
            super((Reader)new StringReader(source));
        }
    }
}

