/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.row;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.connection.DefaultDbConnection;
import org.mule.db.commons.internal.result.row.InsensitiveMapRowHandler;
import org.mule.runtime.api.metadata.TypedValue;

public class InsensitiveMapRowHandlerTestCase {
    private DefaultDbConnection defaultDbConnection;
    private ResultSet resultSet;

    @Test
    public void testDB2ClobPreemptivelyConsumption() throws Exception {
        this.mockClobDataForDB2();
        InsensitiveMapRowHandler insensitiveMapRowHandler = new InsensitiveMapRowHandler((DbConnection)this.defaultDbConnection);
        Map result = insensitiveMapRowHandler.process(this.resultSet);
        for (Map.Entry entry : result.entrySet()) {
            if (!((String)entry.getKey()).equals("ClobColumn")) continue;
            Assert.assertFalse((boolean)((TypedValue)entry.getValue()).getDataType().isStreamType());
        }
    }

    private void mockClobDataForDB2() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        FakeClob clob = new FakeClob();
        clob.setString(1L, RandomStringUtils.randomPrint((int)10000));
        this.resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)metadata);
        Mockito.when((Object)metadata.getDatabaseProductName()).thenReturn((Object)"DB2");
        Mockito.when((Object)resultSetMetaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(1)).thenReturn((Object)"IdColumn");
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn((Object)333);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(2)).thenReturn((Object)"ClobColumn");
        Mockito.when((Object)this.resultSet.getObject(2)).thenReturn((Object)clob);
        Mockito.when((Object)this.resultSet.getMetaData()).thenReturn((Object)resultSetMetaData);
        Mockito.when((Object)this.resultSet.next()).thenReturn((Object)true).thenReturn((Object)false);
        this.defaultDbConnection = new DefaultDbConnection(connection, new ArrayList());
    }

    private static class FakeClob
    implements Clob {
        private String str;

        private FakeClob() {
        }

        @Override
        public long length() throws SQLException {
            return 0L;
        }

        @Override
        public String getSubString(long pos, int length) throws SQLException {
            return null;
        }

        @Override
        public Reader getCharacterStream() throws SQLException {
            return new StringReader(this.str);
        }

        @Override
        public InputStream getAsciiStream() throws SQLException {
            return null;
        }

        @Override
        public long position(String searchstr, long start) throws SQLException {
            return 0L;
        }

        @Override
        public long position(Clob searchstr, long start) throws SQLException {
            return 0L;
        }

        @Override
        public int setString(long pos, String str) throws SQLException {
            this.str = str;
            return 0;
        }

        @Override
        public int setString(long pos, String str, int offset, int len) throws SQLException {
            this.str = str;
            return 0;
        }

        @Override
        public OutputStream setAsciiStream(long pos) throws SQLException {
            return null;
        }

        @Override
        public Writer setCharacterStream(long pos) throws SQLException {
            return null;
        }

        @Override
        public void truncate(long len) throws SQLException {
        }

        @Override
        public void free() throws SQLException {
        }

        @Override
        public Reader getCharacterStream(long pos, long length) throws SQLException {
            return null;
        }
    }
}

