/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;
import org.mule.runtime.api.metadata.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClobResolvedDataType
extends ResolvedDbType {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClobResolvedDataType.class);
    private static final String JTDS_DRIVER = "jTDS";

    public ClobResolvedDataType(int id, String name) {
        super(id, name);
    }

    @Override
    public void setParameterValue(PreparedStatement statement, int index, Object value, DbConnection connection) throws SQLException {
        if (value != null && !(value instanceof Clob)) {
            Reader reader = this.getReaderFromValue(value);
            try {
                LOGGER.debug("Creating CLOB object");
                Clob clob = statement.getConnection().createClob();
                Writer writer = clob.setCharacterStream(1L);
                IOUtils.copyLarge((Reader)reader, (Writer)writer);
                super.setParameterValue(statement, index, clob, connection);
            }
            catch (Exception e) {
                LOGGER.debug("Error creating CLOB object. Using alternative way to set CLOB object", (Throwable)e);
                this.handlePriorVersions(statement, index, reader);
            }
        } else {
            super.setParameterValue(statement, index, value, connection);
        }
    }

    private Reader getReaderFromValue(Object value) {
        if (value instanceof String) {
            return new StringReader((String)value);
        }
        if (value instanceof InputStream) {
            return new InputStreamReader((InputStream)value);
        }
        if (value instanceof TypedValue && ((TypedValue)value).getValue() instanceof InputStream) {
            return new InputStreamReader((InputStream)((TypedValue)value).getValue());
        }
        throw new IllegalArgumentException(String.format("Cannot create a Clob from a value of type '%s'", value.getClass()));
    }

    private void handlePriorVersions(PreparedStatement statement, int index, Reader reader) throws SQLException {
        DatabaseMetaData metaData = statement.getConnection().getMetaData();
        if (metaData != null && metaData.getDriverName() != null && metaData.getDriverName().contains(JTDS_DRIVER)) {
            try {
                statement.setString(index, IOUtils.toString((Reader)reader));
            }
            catch (IOException ex) {
                LOGGER.error("Exception while reading CLOB Contents (jTDS)", (Throwable)ex);
                throw new SQLException("Exception while reading CLOB Contents (jTDS)", ex);
            }
        } else {
            statement.setCharacterStream(index, reader);
        }
    }
}

