/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.db.internal.domain.statement;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.domain.statement.QueryStatementFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class QueryStatementFactoryTestCase
extends AbstractMuleTestCase {
    private final String sqlText = "call test";
    private CallableStatement createdStatement;
    private DatabaseMetaData metadata;
    private DbConnection connection;
    private Connection jdbcConnection;

    @Before
    public void setUp() throws Exception {
        this.createdStatement = (CallableStatement)Mockito.mock(CallableStatement.class);
        this.metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        this.connection = (DbConnection)Mockito.mock(DbConnection.class);
        this.jdbcConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.connection.getJdbcConnection()).thenReturn((Object)this.jdbcConnection);
    }

    @Test
    public void createsPreparedStatementsWithScrolling() throws SQLException {
        Mockito.when((Object)this.metadata.supportsResultSetType(1004)).thenReturn((Object)true);
        Mockito.when((Object)this.jdbcConnection.getMetaData()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.jdbcConnection.prepareCall("call test", 1004, 1007)).thenReturn((Object)this.createdStatement);
        this.checkStatementCreated(this.connection);
    }

    @Test
    public void createsPreparedStatementsWithForwardOnly() throws SQLException {
        Mockito.when((Object)this.metadata.supportsResultSetType(1004)).thenReturn((Object)false);
        Mockito.when((Object)this.metadata.supportsResultSetType(1005)).thenReturn((Object)false);
        Mockito.when((Object)this.jdbcConnection.getMetaData()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.jdbcConnection.prepareCall("call test", 1003, 1007)).thenReturn((Object)this.createdStatement);
        this.checkStatementCreated(this.connection);
    }

    private void checkStatementCreated(DbConnection connection) throws SQLException {
        QueryStatementFactory factory = new QueryStatementFactory();
        QueryTemplate queryTemplate = new QueryTemplate("call test", QueryType.STORE_PROCEDURE_CALL, Collections.emptyList());
        CallableStatement statement = (CallableStatement)factory.create(connection, queryTemplate);
        Assert.assertThat((Object)statement, (Matcher)Matchers.is((Object)this.createdStatement));
    }
}

