/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection.enhydra.wrappers;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.enhydra.jdbc.standard.StandardDataSource;
import org.mule.db.commons.internal.util.ClassUtils;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnhydraWrapperUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnhydraWrapperUtils.class);
    private static final String SSL_KEYSTORE = "javax.net.ssl.keyStore";
    private static final String SSL_KEYSTORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String SSL_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String SSL_TRUSTSTORE = "javax.net.ssl.trustStore";
    private static final String SSL_TRUSTSTORE_TYPE = "javax.net.ssl.trustStoreType";
    private static final String SSL_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";

    private EnhydraWrapperUtils() {
    }

    public static synchronized Connection getSecureConnectionIfPossible(String user, String password, StandardDataSource wrappedDataSource, TlsContextFactory tlsContextFactory) throws SQLException {
        try {
            boolean hasPassword;
            Connection ret = null;
            Properties prop = new Properties();
            String url = (String)ClassUtils.getFieldValue(wrappedDataSource, "url", true);
            Driver driver = (Driver)ClassUtils.getFieldValue(wrappedDataSource, "driver", true);
            String driverName = (String)ClassUtils.getFieldValue(wrappedDataSource, "driverName", true);
            boolean loadedFromCCL = (Boolean)ClassUtils.getFieldValue(wrappedDataSource, "loadedFromCCL", true);
            boolean hasUser = user != null && !user.isEmpty();
            boolean bl = hasPassword = password != null && !password.isEmpty();
            if (hasUser) {
                prop.put("user", user);
            }
            if (hasPassword) {
                prop.put("password", password);
            }
            if (!hasUser && !hasPassword && tlsContextFactory != null && tlsContextFactory.isKeyStoreConfigured() && tlsContextFactory.isTrustStoreConfigured()) {
                prop.put("oracle.net.authentication_services", "(TCPS)");
            }
            EnhydraWrapperUtils.setTLSProperties(prop, tlsContextFactory);
            if (url != null) {
                if (driver == null) {
                    try {
                        driver = (Driver)Class.forName(driverName).newInstance();
                        loadedFromCCL = false;
                        wrappedDataSource.log.debug((Object)"StandardDataSource:getConnection a new driver instance is created");
                    }
                    catch (Exception e) {
                        try {
                            driver = (Driver)Class.forName(driverName, true, Thread.currentThread().getContextClassLoader()).newInstance();
                            loadedFromCCL = true;
                        }
                        catch (Exception e2) {
                            String errorMessage = "Error trying to load driver: " + driverName + " : " + e2.getMessage();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("An error occurred during getConnection execution: {}", (Object)errorMessage);
                            }
                            throw new SQLException(errorMessage);
                        }
                    }
                }
                try {
                    ret = loadedFromCCL ? driver.connect(url, prop) : DriverManager.getConnection(url, prop);
                    int transIsolation = wrappedDataSource.getTransactionIsolation();
                    if (transIsolation >= 0) {
                        ret.setTransactionIsolation(transIsolation);
                    }
                    wrappedDataSource.log.debug((Object)"StandardDataSource:getConnection Connection from DriverManager is returned");
                }
                catch (SQLException e) {
                    String errorMessage = "Cannot get connection for URL " + url + " : " + e.getMessage();
                    LOGGER.error(errorMessage, (Throwable)e);
                    throw new SQLException(errorMessage, e.getSQLState(), e.getErrorCode(), e.getCause());
                }
            }
            return ret;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            String errorMessage = "An error occurred during getConnection execution: " + e.getMessage();
            LOGGER.error(errorMessage, (Throwable)e);
            throw new SQLException(errorMessage, e);
        }
    }

    public static void setTLSProperties(Properties prop, TlsContextFactory tlsContextFactory) {
        if (tlsContextFactory == null) {
            return;
        }
        if (tlsContextFactory.isKeyStoreConfigured()) {
            if (!tlsContextFactory.getKeyStoreConfiguration().getPath().isEmpty()) {
                prop.put(SSL_KEYSTORE, tlsContextFactory.getKeyStoreConfiguration().getPath());
            }
            if (!tlsContextFactory.getKeyStoreConfiguration().getType().isEmpty()) {
                prop.put(SSL_KEYSTORE_TYPE, tlsContextFactory.getKeyStoreConfiguration().getType());
            }
            if (!tlsContextFactory.getKeyStoreConfiguration().getPassword().isEmpty()) {
                prop.put(SSL_KEYSTORE_PASSWORD, tlsContextFactory.getKeyStoreConfiguration().getPassword());
            }
        }
        if (tlsContextFactory.isTrustStoreConfigured()) {
            if (!tlsContextFactory.getTrustStoreConfiguration().getPath().isEmpty()) {
                prop.put(SSL_TRUSTSTORE, tlsContextFactory.getTrustStoreConfiguration().getPath());
            }
            if (!tlsContextFactory.getTrustStoreConfiguration().getType().isEmpty()) {
                prop.put(SSL_TRUSTSTORE_TYPE, tlsContextFactory.getTrustStoreConfiguration().getType());
            }
            if (!tlsContextFactory.getTrustStoreConfiguration().getPassword().isEmpty()) {
                prop.put(SSL_TRUSTSTORE_PASSWORD, tlsContextFactory.getTrustStoreConfiguration().getPassword());
            }
        }
    }
}

