/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import org.mule.db.commons.internal.domain.query.QueryType;

/**
 * Utility Class to detect an Insert Statement
 */
public class InsertStatementTypeDetector extends AbstractStatementTypeDetector {

  private static final String INSERT_REGEX = String.format(OPERATION_REGEX_TEMPLATE, "INSERT");

  public InsertStatementTypeDetector() {
    super(QueryType.INSERT, INSERT_REGEX);
  }

}
