/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.domain.autogeneratedkey;

import java.util.List;

/**
 * Parameters to configure if and how should keys be auto generated
 *
 * @since 1.0
 */
public interface AutoGenerateKeysAttributes {

  String AUTO_GENERATE_KEYS = "Auto Generate Keys";

  boolean isAutoGenerateKeys();

  List<Integer> getAutoGeneratedKeysColumnIndexes();

  List<String> getAutoGeneratedKeysColumnNames();

}
