/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.api.param;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * The definition for a DML query
 *
 * @since 1.0
 */
public class QueryDefinition extends ParameterizedStatementDefinition<QueryDefinition> {

  /**
   * Creates a new Instance of QueryDefinition.
   */
  public QueryDefinition() {}

  /**
   * Creates a mew Instance of QueryDefinition with the given arguments.
   * 
   * @param sql              The text of the SQL query to be executed
   * @param parameterTypes   Allows to optionally specify the type of one or more of the parameters in the query. If provided,
   *                         you're not even required to reference all of the parameters, but you cannot reference a parameter not
   *                         present in the input values
   * @param inputParameters  A {@link Map} which keys are the name of an input parameter to be set on the JDBC prepared statement.
   *                         Each parameter should be referenced in the sql text using a semicolon prefix (E.g:
   *                         {@code where id = :myParamName)}).
   *                         <p>
   *                         The map's values will contain the actual assignation for each parameter.
   * @param queryTimeout     Indicates the minimum amount of time before the JDBC driver attempts to cancel a running statement.
   *                         No timeout is used by default.
   * @param queryTimeoutUnit A {@link TimeUnit} which qualifies the {@link #queryTimeout}
   * @param fetchSize        Indicates how many rows to fetch from the database when rows are read from a resultSet.
   * @param maxRows          * Sets the limit for the maximum number of rows that any ResultSet object generated by this message
   *                         processor can contain for the given number. If the limit is exceeded, the excess rows are silently
   *                         dropped.
   */
  public QueryDefinition(String sql, List<ParameterType> parameterTypes, Map<String, Object> inputParameters, int queryTimeout,
                         TimeUnit queryTimeoutUnit, Integer fetchSize, Integer maxRows) {
    super(sql, parameterTypes, inputParameters, queryTimeout, queryTimeoutUnit, fetchSize, maxRows);
  }


}
