/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import org.mule.db.commons.internal.domain.query.QueryType;

/**
 * Utility class to detect Update Statements.
 */
public class UpdateStatementTypeDetector extends AbstractStatementTypeDetector {

  private static final String UPDATE_REGEX = String.format(OPERATION_REGEX_TEMPLATE, "UPDATE");

  public UpdateStatementTypeDetector() {
    super(QueryType.UPDATE, UPDATE_REGEX);
  }
}
