/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.domain.autogeneratedkey;

import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class ColumnIndexAutoGenerateKeysStrategy implements AutoGenerateKeysStrategy {

  private final int[] columnIndexes;

  public ColumnIndexAutoGenerateKeysStrategy(int[] columnIndexes) {
    this.columnIndexes = columnIndexes;
  }

  @Override
  public boolean returnsAutoGenerateKeys() {
    return true;
  }

  @Override
  public PreparedStatement prepareStatement(DbConnection connection, QueryTemplate queryTemplate) throws SQLException {
    return connection.getJdbcConnection().prepareStatement(queryTemplate.getSqlText(), columnIndexes);
  }

  @Override
  public boolean execute(Statement statement, QueryTemplate queryTemplate) throws SQLException {
    if (statement instanceof PreparedStatement) {
      return ((PreparedStatement) statement).execute();
    } else {
      return statement.execute(queryTemplate.getSqlText(), columnIndexes);
    }
  }

  @Override
  public int executeUpdate(Statement statement, QueryTemplate queryTemplate) throws SQLException {
    if (statement instanceof PreparedStatement) {
      return ((PreparedStatement) statement).executeUpdate();
    } else {
      return statement.executeUpdate(queryTemplate.getSqlText(), columnIndexes);
    }
  }
}
