/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons;

import java.nio.charset.Charset;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.db.commons.AbstractDbConnector;
import org.mule.db.commons.internal.domain.type.DbTypeManager;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class AbstractDbConnectorTestCase
extends AbstractMuleTestCase {
    private static final String CONNECTOR_ENCODING_UTF_8 = "UTF-8";
    public static final String CONNECTOR_ENCODING_ISO_8858_1 = "ISO-8859-1";
    private TestDbConnector connector;

    @Before
    public void setUp() {
        this.connector = new TestDbConnector();
        this.connector.encoding = CONNECTOR_ENCODING_UTF_8;
    }

    @Test
    public void testInitialiseCreatesTypeManager() throws InitialisationException {
        this.connector.initialise();
        DbTypeManager typeManager = this.connector.getTypeManager();
        MatcherAssert.assertThat((Object)typeManager, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testInitialiseCreatesCharset() throws InitialisationException {
        this.connector.initialise();
        Charset charset = this.connector.getCharset();
        MatcherAssert.assertThat((Object)charset, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)charset.name(), (Matcher)CoreMatchers.is((Object)CONNECTOR_ENCODING_UTF_8));
    }

    @Test
    public void testInitialiseWithCustomEncoding() throws InitialisationException {
        this.connector.encoding = CONNECTOR_ENCODING_ISO_8858_1;
        this.connector.initialise();
        Charset charset = this.connector.getCharset();
        MatcherAssert.assertThat((Object)charset, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)charset.name(), (Matcher)CoreMatchers.is((Object)CONNECTOR_ENCODING_ISO_8858_1));
    }

    @Test
    public void testGetTypeManagerBeforeInitialise() {
        DbTypeManager typeManager = this.connector.getTypeManager();
        MatcherAssert.assertThat((Object)typeManager, (Matcher)CoreMatchers.is((Object)null));
    }

    @Test
    public void testGetCharsetBeforeInitialise() {
        Charset charset = this.connector.getCharset();
        MatcherAssert.assertThat((Object)charset, (Matcher)CoreMatchers.is((Object)null));
    }

    @Test
    public void testClassImplementsInitialisable() {
        MatcherAssert.assertThat((Object)(this.connector instanceof Initialisable), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testClassHasCorrectPackage() {
        MatcherAssert.assertThat((Object)((Object)((Object)this.connector)).getClass().getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons"));
    }

    @Test
    public void testClassHasCorrectName() {
        MatcherAssert.assertThat((Object)((Object)((Object)this.connector)).getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"TestDbConnector"));
    }

    @Test
    public void testCreateBaseTypeManager() {
        DbTypeManager typeManager = this.connector.createBaseTypeManager();
        MatcherAssert.assertThat((Object)typeManager, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testInitialiseMultipleTimes() throws InitialisationException {
        this.connector.initialise();
        this.connector.initialise();
        DbTypeManager secondTypeManager = this.connector.getTypeManager();
        Charset secondCharset = this.connector.getCharset();
        MatcherAssert.assertThat((Object)secondTypeManager, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)secondCharset, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testInitialiseWithNullEncoding() {
        this.connector.encoding = null;
    }

    @Test
    public void testInitialiseWithEmptyEncoding() {
        this.connector.encoding = "";
    }

    private static class TestDbConnector
    extends AbstractDbConnector {
        private TestDbConnector() {
        }
    }
}

