/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.api.DbAggregate;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DbAggregateTestCase
extends AbstractMuleTestCase {
    @Test
    public void testConstructorWithValidParameters() {
        List<Object> elements = Arrays.asList("item1", "item2", "item3");
        String typeName = "VARCHAR";
        DbAggregate.Kind kind = DbAggregate.Kind.ARRAY;
        DbAggregate aggregate = new DbAggregate(kind, typeName, elements);
        MatcherAssert.assertThat((Object)aggregate, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)aggregate.getKind(), (Matcher)CoreMatchers.is((Object)kind));
        MatcherAssert.assertThat((Object)aggregate.getTypeName(), (Matcher)CoreMatchers.is((Object)typeName));
        MatcherAssert.assertThat((Object)aggregate.getElements(), (Matcher)CoreMatchers.is(elements));
        MatcherAssert.assertThat((Object)aggregate.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testConstructorWithEmptyElements() {
        List elements = Collections.emptyList();
        String typeName = "VARCHAR";
        DbAggregate.Kind kind = DbAggregate.Kind.ARRAY;
        DbAggregate aggregate = new DbAggregate(kind, typeName, elements);
        MatcherAssert.assertThat((Object)aggregate, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)aggregate.getKind(), (Matcher)CoreMatchers.is((Object)kind));
        MatcherAssert.assertThat((Object)aggregate.getTypeName(), (Matcher)CoreMatchers.is((Object)typeName));
        MatcherAssert.assertThat((Object)aggregate.getElements(), (Matcher)CoreMatchers.is(elements));
        MatcherAssert.assertThat((Object)aggregate.size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertTrue((boolean)aggregate.isEmpty());
    }

    @Test
    public void testConstructorWithStructKind() {
        List<Object> elements = Arrays.asList("field1", "field2");
        String typeName = "TEST_STRUCT";
        DbAggregate.Kind kind = DbAggregate.Kind.STRUCT;
        DbAggregate aggregate = new DbAggregate(kind, typeName, elements);
        MatcherAssert.assertThat((Object)aggregate, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)aggregate.getKind(), (Matcher)CoreMatchers.is((Object)kind));
        MatcherAssert.assertThat((Object)aggregate.getTypeName(), (Matcher)CoreMatchers.is((Object)typeName));
        MatcherAssert.assertThat((Object)aggregate.getElements(), (Matcher)CoreMatchers.is(elements));
        MatcherAssert.assertThat((Object)aggregate.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testGetElementByIndex() {
        List<Object> elements = Arrays.asList("item1", "item2", "item3");
        DbAggregate aggregate = new DbAggregate(DbAggregate.Kind.ARRAY, "VARCHAR", elements);
        MatcherAssert.assertThat((Object)aggregate.get(0), (Matcher)CoreMatchers.is((Object)"item1"));
        MatcherAssert.assertThat((Object)aggregate.get(1), (Matcher)CoreMatchers.is((Object)"item2"));
        MatcherAssert.assertThat((Object)aggregate.get(2), (Matcher)CoreMatchers.is((Object)"item3"));
    }

    @Test
    public void testSize() {
        List<Object> elements = Arrays.asList("item1", "item2", "item3", "item4");
        DbAggregate aggregate = new DbAggregate(DbAggregate.Kind.ARRAY, "VARCHAR", elements);
        MatcherAssert.assertThat((Object)aggregate.size(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void testToArray() {
        List<Object> elements = Arrays.asList("item1", "item2", "item3");
        DbAggregate aggregate = new DbAggregate(DbAggregate.Kind.ARRAY, "VARCHAR", elements);
        Object[] result = aggregate.toArray();
        Assert.assertArrayEquals((Object[])elements.toArray(), (Object[])result);
    }

    @Test
    public void testToArrayWithType() {
        List<Object> elements = Arrays.asList("item1", "item2", "item3");
        DbAggregate aggregate = new DbAggregate(DbAggregate.Kind.ARRAY, "VARCHAR", elements);
        Object[] targetArray = new String[3];
        Object[] result = (String[])aggregate.toArray(targetArray);
        Assert.assertArrayEquals((Object[])elements.toArray(new String[0]), (Object[])result);
    }

    @Test
    public void testElementsAreImmutable() {
        List<Object> originalElements = Arrays.asList("item1", "item2");
        DbAggregate aggregate = new DbAggregate(DbAggregate.Kind.ARRAY, "VARCHAR", originalElements);
        List returnedElements = aggregate.getElements();
        MatcherAssert.assertThat((Object)returnedElements, (Matcher)CoreMatchers.is(originalElements));
    }

    @Test
    public void testKindEnumValues() {
        MatcherAssert.assertThat((Object)DbAggregate.Kind.ARRAY, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)DbAggregate.Kind.STRUCT, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testClassHasCorrectPackage() {
        DbAggregate aggregate = new DbAggregate(DbAggregate.Kind.ARRAY, "VARCHAR", Collections.emptyList());
        MatcherAssert.assertThat((Object)aggregate.getClass().getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.api"));
    }

    @Test
    public void testClassHasCorrectName() {
        DbAggregate aggregate = new DbAggregate(DbAggregate.Kind.ARRAY, "VARCHAR", Collections.emptyList());
        MatcherAssert.assertThat((Object)aggregate.getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"DbAggregate"));
    }

    @Test
    public void testIsEmpty() {
        DbAggregate emptyAggregate = new DbAggregate(DbAggregate.Kind.ARRAY, "VARCHAR", Collections.emptyList());
        DbAggregate nonEmptyAggregate = new DbAggregate(DbAggregate.Kind.ARRAY, "VARCHAR", Arrays.asList("item1"));
        Assert.assertTrue((boolean)emptyAggregate.isEmpty());
        Assert.assertFalse((boolean)nonEmptyAggregate.isEmpty());
    }

    @Test
    public void testContains() {
        List<Object> elements = Arrays.asList("item1", "item2", "item3");
        DbAggregate aggregate = new DbAggregate(DbAggregate.Kind.ARRAY, "VARCHAR", elements);
        Assert.assertTrue((boolean)aggregate.contains((Object)"item1"));
        Assert.assertTrue((boolean)aggregate.contains((Object)"item2"));
        Assert.assertTrue((boolean)aggregate.contains((Object)"item3"));
        Assert.assertFalse((boolean)aggregate.contains((Object)"item4"));
    }

    @Test
    public void testIndexOf() {
        List<Object> elements = Arrays.asList("item1", "item2", "item1", "item3");
        DbAggregate aggregate = new DbAggregate(DbAggregate.Kind.ARRAY, "VARCHAR", elements);
        Assert.assertEquals((long)0L, (long)aggregate.indexOf((Object)"item1"));
        Assert.assertEquals((long)1L, (long)aggregate.indexOf((Object)"item2"));
        Assert.assertEquals((long)3L, (long)aggregate.indexOf((Object)"item3"));
        Assert.assertEquals((long)-1L, (long)aggregate.indexOf((Object)"item4"));
    }

    @Test
    public void testLastIndexOf() {
        List<Object> elements = Arrays.asList("item1", "item2", "item1", "item3");
        DbAggregate aggregate = new DbAggregate(DbAggregate.Kind.ARRAY, "VARCHAR", elements);
        Assert.assertEquals((long)2L, (long)aggregate.lastIndexOf((Object)"item1"));
        Assert.assertEquals((long)1L, (long)aggregate.lastIndexOf((Object)"item2"));
        Assert.assertEquals((long)3L, (long)aggregate.lastIndexOf((Object)"item3"));
        Assert.assertEquals((long)-1L, (long)aggregate.lastIndexOf((Object)"item4"));
    }
}

