/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.internal.StatementStreamingResultSetCloser;
import org.mule.db.commons.internal.domain.connection.DbConnection;

@RunWith(value=MockitoJUnitRunner.class)
public class StatementStreamingResultSetCloserTestCase {
    @Mock
    private DbConnection mockConnection;
    @Mock
    private ResultSet mockResultSet1;
    @Mock
    private ResultSet mockResultSet2;
    private StatementStreamingResultSetCloser closer;

    @Before
    public void setUp() {
        this.closer = new StatementStreamingResultSetCloser(this.mockConnection);
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.closer);
        Assert.assertEquals((long)0L, (long)this.closer.getOpenResultSets());
    }

    @Test
    public void testTrackResultSet() {
        this.closer.trackResultSet(this.mockResultSet1);
        Assert.assertEquals((long)1L, (long)this.closer.getOpenResultSets());
        this.closer.trackResultSet(this.mockResultSet2);
        Assert.assertEquals((long)2L, (long)this.closer.getOpenResultSets());
    }

    @Test(expected=NullPointerException.class)
    public void testTrackResultSetWithNull() {
        this.closer.trackResultSet(null);
    }

    @Test
    public void testCloseResultSetsSuccess() throws SQLException {
        Mockito.when((Object)this.mockResultSet1.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.mockResultSet2.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.mockConnection.isTransactionActive()).thenReturn((Object)false);
        this.closer.trackResultSet(this.mockResultSet1);
        this.closer.trackResultSet(this.mockResultSet2);
        this.closer.closeResultSets();
        ((ResultSet)Mockito.verify((Object)this.mockResultSet1)).close();
        ((ResultSet)Mockito.verify((Object)this.mockResultSet2)).close();
        ((DbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.times((int)2))).endStreaming();
        ((DbConnection)Mockito.verify((Object)this.mockConnection)).release();
        Assert.assertEquals((long)0L, (long)this.closer.getOpenResultSets());
    }

    @Test
    public void testCloseResultSetsWithAlreadyClosedResultSet() throws SQLException {
        Mockito.when((Object)this.mockResultSet1.isClosed()).thenReturn((Object)true);
        Mockito.when((Object)this.mockConnection.isTransactionActive()).thenReturn((Object)false);
        this.closer.trackResultSet(this.mockResultSet1);
        this.closer.closeResultSets();
        ((ResultSet)Mockito.verify((Object)this.mockResultSet1, (VerificationMode)Mockito.never())).close();
        ((DbConnection)Mockito.verify((Object)this.mockConnection)).endStreaming();
        ((DbConnection)Mockito.verify((Object)this.mockConnection)).release();
        Assert.assertEquals((long)0L, (long)this.closer.getOpenResultSets());
    }

    @Test
    public void testCloseResultSetsWithSQLException() throws SQLException {
        Mockito.when((Object)this.mockResultSet1.isClosed()).thenReturn((Object)false);
        ((ResultSet)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("Test exception")}).when((Object)this.mockResultSet1)).close();
        Mockito.when((Object)this.mockConnection.isTransactionActive()).thenReturn((Object)false);
        this.closer.trackResultSet(this.mockResultSet1);
        this.closer.closeResultSets();
        ((ResultSet)Mockito.verify((Object)this.mockResultSet1)).close();
        ((DbConnection)Mockito.verify((Object)this.mockConnection)).endStreaming();
        ((DbConnection)Mockito.verify((Object)this.mockConnection)).release();
        Assert.assertEquals((long)0L, (long)this.closer.getOpenResultSets());
    }

    @Test
    public void testCloseResultSetsWithActiveTransaction() throws SQLException {
        Mockito.when((Object)this.mockResultSet1.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.mockConnection.isTransactionActive()).thenReturn((Object)true);
        this.closer.trackResultSet(this.mockResultSet1);
        this.closer.closeResultSets();
        ((ResultSet)Mockito.verify((Object)this.mockResultSet1)).close();
        ((DbConnection)Mockito.verify((Object)this.mockConnection)).endStreaming();
        ((DbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).release();
        Assert.assertEquals((long)0L, (long)this.closer.getOpenResultSets());
    }

    @Test
    public void testCloseResultSetsWithMultipleExceptions() throws SQLException {
        Mockito.when((Object)this.mockResultSet1.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.mockResultSet2.isClosed()).thenReturn((Object)false);
        ((ResultSet)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("Exception 1")}).when((Object)this.mockResultSet1)).close();
        ((ResultSet)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("Exception 2")}).when((Object)this.mockResultSet2)).close();
        Mockito.when((Object)this.mockConnection.isTransactionActive()).thenReturn((Object)false);
        this.closer.trackResultSet(this.mockResultSet1);
        this.closer.trackResultSet(this.mockResultSet2);
        this.closer.closeResultSets();
        ((ResultSet)Mockito.verify((Object)this.mockResultSet1)).close();
        ((ResultSet)Mockito.verify((Object)this.mockResultSet2)).close();
        ((DbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.times((int)2))).endStreaming();
        ((DbConnection)Mockito.verify((Object)this.mockConnection)).release();
        Assert.assertEquals((long)0L, (long)this.closer.getOpenResultSets());
    }

    @Test
    public void testGetOpenResultSets() {
        Assert.assertEquals((long)0L, (long)this.closer.getOpenResultSets());
        this.closer.trackResultSet(this.mockResultSet1);
        Assert.assertEquals((long)1L, (long)this.closer.getOpenResultSets());
        this.closer.trackResultSet(this.mockResultSet2);
        Assert.assertEquals((long)2L, (long)this.closer.getOpenResultSets());
    }

    @Test
    public void testCloseResultSetsWithEmptySet() throws SQLException {
        Mockito.when((Object)this.mockConnection.isTransactionActive()).thenReturn((Object)false);
        this.closer.closeResultSets();
        ((DbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).endStreaming();
        ((DbConnection)Mockito.verify((Object)this.mockConnection)).release();
        Assert.assertEquals((long)0L, (long)this.closer.getOpenResultSets());
    }

    @Test(expected=NullPointerException.class)
    public void testCloseResultSetsWithNullConnection() {
        StatementStreamingResultSetCloser nullConnectionCloser = new StatementStreamingResultSetCloser(null);
        nullConnectionCloser.trackResultSet(this.mockResultSet1);
        Assert.assertEquals((long)1L, (long)nullConnectionCloser.getOpenResultSets());
        nullConnectionCloser.closeResultSets();
    }

    @Test
    public void testConcurrentTracking() throws InterruptedException {
        Thread[] threads = new Thread[10];
        for (int i = 0; i < 10; ++i) {
            int index = i;
            threads[i] = new Thread(() -> {
                try {
                    ResultSet mockRs = (ResultSet)Mockito.mock(ResultSet.class);
                    this.closer.trackResultSet(mockRs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        Assert.assertEquals((long)10L, (long)this.closer.getOpenResultSets());
    }
}

