/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.autogeneratedkey;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.autogeneratedkey.ColumnIndexAutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;

@RunWith(value=MockitoJUnitRunner.class)
public class ColumnIndexAutoGenerateKeysStrategyTestCase {
    @Mock
    private DbConnection mockDbConnection;
    @Mock
    private QueryTemplate mockQueryTemplate;
    @Mock
    private Connection mockJdbcConnection;
    @Mock
    private PreparedStatement mockPreparedStatement;
    @Mock
    private Statement mockStatement;
    private ColumnIndexAutoGenerateKeysStrategy strategy;
    private int[] columnIndexes;

    @Before
    public void setUp() {
        this.columnIndexes = new int[]{1, 2};
        this.strategy = new ColumnIndexAutoGenerateKeysStrategy(this.columnIndexes);
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.strategy);
    }

    @Test
    public void testConstructorWithNullColumnIndexes() {
        ColumnIndexAutoGenerateKeysStrategy strategyWithNull = new ColumnIndexAutoGenerateKeysStrategy(null);
        Assert.assertNotNull((Object)strategyWithNull);
    }

    @Test
    public void testConstructorWithEmptyColumnIndexes() {
        ColumnIndexAutoGenerateKeysStrategy strategyWithEmpty = new ColumnIndexAutoGenerateKeysStrategy(new int[0]);
        Assert.assertNotNull((Object)strategyWithEmpty);
    }

    @Test
    public void testReturnsAutoGenerateKeys() {
        boolean result = this.strategy.returnsAutoGenerateKeys();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testPrepareStatement() throws SQLException {
        String sqlText = "INSERT INTO users (name, email) VALUES (?, ?)";
        Mockito.when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)sqlText);
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement(sqlText, this.columnIndexes)).thenReturn((Object)this.mockPreparedStatement);
        PreparedStatement result = this.strategy.prepareStatement(this.mockDbConnection, this.mockQueryTemplate);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.mockPreparedStatement, (Object)result);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection)).getJdbcConnection();
        ((Connection)Mockito.verify((Object)this.mockJdbcConnection)).prepareStatement(sqlText, this.columnIndexes);
    }

    @Test
    public void testPrepareStatementWithNullConnection() {
        Assert.assertThrows(NullPointerException.class, () -> this.strategy.prepareStatement(null, this.mockQueryTemplate));
    }

    @Test
    public void testPrepareStatementWithNullQueryTemplate() {
        Assert.assertThrows(NullPointerException.class, () -> this.strategy.prepareStatement(this.mockDbConnection, null));
    }

    @Test
    public void testPrepareStatementWithSQLException() throws SQLException {
        String sqlText = "INSERT INTO users (name, email) VALUES (?, ?)";
        Mockito.when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)sqlText);
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement(sqlText, this.columnIndexes)).thenThrow(new Throwable[]{new SQLException("Database error")});
        Assert.assertThrows(SQLException.class, () -> this.strategy.prepareStatement(this.mockDbConnection, this.mockQueryTemplate));
    }

    @Test
    public void testExecuteWithPreparedStatement() throws SQLException {
        Mockito.when((Object)this.mockPreparedStatement.execute()).thenReturn((Object)true);
        boolean result = this.strategy.execute((Statement)this.mockPreparedStatement, this.mockQueryTemplate);
        Assert.assertTrue((boolean)result);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).execute();
    }

    @Test
    public void testExecuteWithStatement() throws SQLException {
        String sqlText = "INSERT INTO users (name, email) VALUES ('John', 'john@example.com')";
        Mockito.when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)sqlText);
        Mockito.when((Object)this.mockStatement.execute(sqlText, this.columnIndexes)).thenReturn((Object)true);
        boolean result = this.strategy.execute(this.mockStatement, this.mockQueryTemplate);
        Assert.assertTrue((boolean)result);
        ((Statement)Mockito.verify((Object)this.mockStatement)).execute(sqlText, this.columnIndexes);
    }

    @Test
    public void testExecuteWithNullStatement() {
        Assert.assertThrows(NullPointerException.class, () -> this.strategy.execute(null, this.mockQueryTemplate));
    }

    @Test
    public void testExecuteWithNullQueryTemplate() throws SQLException {
        this.strategy.execute((Statement)this.mockPreparedStatement, null);
    }

    @Test
    public void testExecuteWithSQLException() throws SQLException {
        Mockito.when((Object)this.mockPreparedStatement.execute()).thenThrow(new Throwable[]{new SQLException("Database error")});
        Assert.assertThrows(SQLException.class, () -> this.strategy.execute((Statement)this.mockPreparedStatement, this.mockQueryTemplate));
    }

    @Test
    public void testExecuteUpdateWithPreparedStatement() throws SQLException {
        Mockito.when((Object)this.mockPreparedStatement.executeUpdate()).thenReturn((Object)1);
        int result = this.strategy.executeUpdate((Statement)this.mockPreparedStatement, this.mockQueryTemplate);
        Assert.assertEquals((long)1L, (long)result);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).executeUpdate();
    }

    @Test
    public void testExecuteUpdateWithStatement() throws SQLException {
        String sqlText = "UPDATE users SET name = 'John' WHERE id = 1";
        Mockito.when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)sqlText);
        Mockito.when((Object)this.mockStatement.executeUpdate(sqlText, this.columnIndexes)).thenReturn((Object)1);
        int result = this.strategy.executeUpdate(this.mockStatement, this.mockQueryTemplate);
        Assert.assertEquals((long)1L, (long)result);
        ((Statement)Mockito.verify((Object)this.mockStatement)).executeUpdate(sqlText, this.columnIndexes);
    }

    @Test
    public void testExecuteUpdateWithNullStatement() {
        Assert.assertThrows(NullPointerException.class, () -> this.strategy.executeUpdate(null, this.mockQueryTemplate));
    }

    @Test
    public void testExecuteUpdateWithNullQueryTemplate() throws SQLException {
        this.strategy.executeUpdate((Statement)this.mockPreparedStatement, null);
    }

    @Test
    public void testExecuteUpdateWithSQLException() throws SQLException {
        Mockito.when((Object)this.mockPreparedStatement.executeUpdate()).thenThrow(new Throwable[]{new SQLException("Database error")});
        Assert.assertThrows(SQLException.class, () -> this.strategy.executeUpdate((Statement)this.mockPreparedStatement, this.mockQueryTemplate));
    }

    @Test
    public void testStrategyImplementsAutoGenerateKeysStrategy() {
        Assert.assertTrue((boolean)(this.strategy instanceof AutoGenerateKeysStrategy));
    }

    @Test
    public void testStrategyPackage() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.autogeneratedkey", (Object)ColumnIndexAutoGenerateKeysStrategy.class.getPackage().getName());
    }

    @Test
    public void testStrategyClassName() {
        Assert.assertEquals((Object)"ColumnIndexAutoGenerateKeysStrategy", (Object)ColumnIndexAutoGenerateKeysStrategy.class.getSimpleName());
    }

    @Test
    public void testStrategyFullClassName() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.autogeneratedkey.ColumnIndexAutoGenerateKeysStrategy", (Object)ColumnIndexAutoGenerateKeysStrategy.class.getName());
    }

    @Test
    public void testMultipleInstances() {
        int[] columnIndexes1 = new int[]{1};
        int[] columnIndexes2 = new int[]{2, 3, 4};
        ColumnIndexAutoGenerateKeysStrategy strategy1 = new ColumnIndexAutoGenerateKeysStrategy(columnIndexes1);
        ColumnIndexAutoGenerateKeysStrategy strategy2 = new ColumnIndexAutoGenerateKeysStrategy(columnIndexes2);
        Assert.assertNotNull((Object)strategy1);
        Assert.assertNotNull((Object)strategy2);
        Assert.assertNotSame((Object)strategy1, (Object)strategy2);
        Assert.assertEquals((Object)strategy1.returnsAutoGenerateKeys(), (Object)strategy2.returnsAutoGenerateKeys());
    }

    @Test
    public void testWithSingleColumnIndex() {
        int[] singleIndex = new int[]{1};
        ColumnIndexAutoGenerateKeysStrategy singleStrategy = new ColumnIndexAutoGenerateKeysStrategy(singleIndex);
        boolean result = singleStrategy.returnsAutoGenerateKeys();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testWithMultipleColumnIndexes() {
        int[] multipleIndexes = new int[]{1, 2, 3, 4, 5};
        ColumnIndexAutoGenerateKeysStrategy multipleStrategy = new ColumnIndexAutoGenerateKeysStrategy(multipleIndexes);
        boolean result = multipleStrategy.returnsAutoGenerateKeys();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testWithZeroBasedIndexes() {
        int[] zeroBasedIndexes = new int[]{0, 1, 2};
        ColumnIndexAutoGenerateKeysStrategy zeroBasedStrategy = new ColumnIndexAutoGenerateKeysStrategy(zeroBasedIndexes);
        boolean result = zeroBasedStrategy.returnsAutoGenerateKeys();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testWithNegativeIndexes() {
        int[] negativeIndexes = new int[]{-1, -2};
        ColumnIndexAutoGenerateKeysStrategy negativeStrategy = new ColumnIndexAutoGenerateKeysStrategy(negativeIndexes);
        boolean result = negativeStrategy.returnsAutoGenerateKeys();
        Assert.assertTrue((boolean)result);
    }
}

