/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.db.commons.api.param.TransactionIsolation;
import org.mule.db.commons.internal.domain.connection.DataSourceConfig;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DataSourceConfigTestCase
extends AbstractMuleTestCase {
    @Test
    public void testInterfaceExists() {
        MatcherAssert.assertThat(DataSourceConfig.class, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testInterfacePackage() {
        MatcherAssert.assertThat((Object)DataSourceConfig.class.getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.domain.connection"));
    }

    @Test
    public void testInterfaceName() {
        MatcherAssert.assertThat((Object)DataSourceConfig.class.getSimpleName(), (Matcher)CoreMatchers.is((Object)"DataSourceConfig"));
    }

    @Test
    public void testDefaultGetTlsContextFactoryReturnsEmpty() {
        TestDataSourceConfig config = new TestDataSourceConfig();
        Optional result = config.getTlsContextFactory();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testInterfaceMethodsExist() {
        TestDataSourceConfig config = new TestDataSourceConfig();
        MatcherAssert.assertThat((Object)config.getUrl(), (Matcher)CoreMatchers.is((Object)"jdbc:test:url"));
        MatcherAssert.assertThat((Object)config.getDriverClassName(), (Matcher)CoreMatchers.is((Object)"com.test.Driver"));
        MatcherAssert.assertThat((Object)config.getPassword(), (Matcher)CoreMatchers.is((Object)"testPassword"));
        MatcherAssert.assertThat((Object)config.getUser(), (Matcher)CoreMatchers.is((Object)"testUser"));
        MatcherAssert.assertThat((Object)config.getTransactionIsolation(), (Matcher)CoreMatchers.is((Object)TransactionIsolation.READ_COMMITTED));
        MatcherAssert.assertThat((Object)config.isUseXaTransactions(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testInterfaceCanBeImplemented() {
        TestDataSourceConfig config = new TestDataSourceConfig();
        MatcherAssert.assertThat((Object)(config instanceof DataSourceConfig), (Matcher)CoreMatchers.is((Object)true));
    }

    private class TestDataSourceConfig
    implements DataSourceConfig {
        private String url = "jdbc:test:url";
        private String driverClassName = "com.test.Driver";
        private String password = "testPassword";
        private String user = "testUser";
        private TransactionIsolation transactionIsolation = TransactionIsolation.READ_COMMITTED;
        private boolean useXaTransactions = false;

        private TestDataSourceConfig() {
        }

        public String getUrl() {
            return this.url;
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUser() {
            return this.user;
        }

        public TransactionIsolation getTransactionIsolation() {
            return this.transactionIsolation;
        }

        public boolean isUseXaTransactions() {
            return this.useXaTransactions;
        }
    }
}

