/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection.datasource;

import java.lang.reflect.Field;
import javax.sql.DataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.datasource.DataSourceConnectionSettings;
import org.mule.db.commons.internal.domain.connection.datasource.DefaultDatasourceConnectionSettings;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultDatasourceConnectionSettingsTestCase
extends AbstractMuleTestCase {
    private DefaultDatasourceConnectionSettings settings;
    private DataSource mockDataSource;

    @Before
    public void setUp() {
        this.settings = new DefaultDatasourceConnectionSettings();
        this.mockDataSource = (DataSource)Mockito.mock(DataSource.class);
    }

    @Test
    public void testGetDataSourceRefReturnsNullByDefault() {
        DataSource result = this.settings.getDataSourceRef();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetDataSourceRefReturnsSetValue() throws Exception {
        Field field = DefaultDatasourceConnectionSettings.class.getDeclaredField("dataSourceRef");
        field.setAccessible(true);
        field.set(this.settings, this.mockDataSource);
        DataSource result = this.settings.getDataSourceRef();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.mockDataSource));
    }

    @Test
    public void testClassImplementsDataSourceConnectionSettings() {
        MatcherAssert.assertThat((Object)(this.settings instanceof DataSourceConnectionSettings), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testClassHasCorrectPackage() {
        MatcherAssert.assertThat((Object)this.settings.getClass().getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.domain.connection.datasource"));
    }

    @Test
    public void testClassHasCorrectName() {
        MatcherAssert.assertThat((Object)this.settings.getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"DefaultDatasourceConnectionSettings"));
    }
}

