/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection.enhydra.wrappers;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.connection.enhydra.wrappers.EnhydraWrapperUtils;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextKeyStoreConfiguration;
import org.mule.runtime.api.tls.TlsContextTrustStoreConfiguration;

@RunWith(value=MockitoJUnitRunner.class)
public class EnhydraWrapperUtilsTestCase {
    @Mock
    private TlsContextFactory mockTlsContextFactory;
    @Mock
    private TlsContextKeyStoreConfiguration mockKeyStoreConfig;
    @Mock
    private TlsContextTrustStoreConfiguration mockTrustStoreConfig;

    @Test
    public void testSetTLSPropertiesWithNullTlsContextFactory() {
        Properties prop = new Properties();
        EnhydraWrapperUtils.setTLSProperties((Properties)prop, null);
        Assert.assertTrue((boolean)prop.isEmpty());
    }

    @Test
    public void testSetTLSPropertiesWithKeyStoreConfigured() {
        Properties prop = new Properties();
        Mockito.when((Object)this.mockTlsContextFactory.isKeyStoreConfigured()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTlsContextFactory.getKeyStoreConfiguration()).thenReturn((Object)this.mockKeyStoreConfig);
        Mockito.when((Object)this.mockKeyStoreConfig.getPath()).thenReturn((Object)"/path/to/keystore.jks");
        Mockito.when((Object)this.mockKeyStoreConfig.getType()).thenReturn((Object)"JKS");
        Mockito.when((Object)this.mockKeyStoreConfig.getPassword()).thenReturn((Object)"keystorePassword");
        EnhydraWrapperUtils.setTLSProperties((Properties)prop, (TlsContextFactory)this.mockTlsContextFactory);
        Assert.assertEquals((Object)"/path/to/keystore.jks", (Object)prop.getProperty("javax.net.ssl.keyStore"));
        Assert.assertEquals((Object)"JKS", (Object)prop.getProperty("javax.net.ssl.keyStoreType"));
        Assert.assertEquals((Object)"keystorePassword", (Object)prop.getProperty("javax.net.ssl.keyStorePassword"));
    }

    @Test
    public void testSetTLSPropertiesWithTrustStoreConfigured() {
        Properties prop = new Properties();
        Mockito.when((Object)this.mockTlsContextFactory.isTrustStoreConfigured()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTlsContextFactory.getTrustStoreConfiguration()).thenReturn((Object)this.mockTrustStoreConfig);
        Mockito.when((Object)this.mockTrustStoreConfig.getPath()).thenReturn((Object)"/path/to/truststore.jks");
        Mockito.when((Object)this.mockTrustStoreConfig.getType()).thenReturn((Object)"JKS");
        Mockito.when((Object)this.mockTrustStoreConfig.getPassword()).thenReturn((Object)"truststorePassword");
        EnhydraWrapperUtils.setTLSProperties((Properties)prop, (TlsContextFactory)this.mockTlsContextFactory);
        Assert.assertEquals((Object)"/path/to/truststore.jks", (Object)prop.getProperty("javax.net.ssl.trustStore"));
        Assert.assertEquals((Object)"JKS", (Object)prop.getProperty("javax.net.ssl.trustStoreType"));
        Assert.assertEquals((Object)"truststorePassword", (Object)prop.getProperty("javax.net.ssl.trustStorePassword"));
    }

    @Test
    public void testSetTLSPropertiesWithBothKeyStoreAndTrustStoreConfigured() {
        Properties prop = new Properties();
        Mockito.when((Object)this.mockTlsContextFactory.isKeyStoreConfigured()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTlsContextFactory.isTrustStoreConfigured()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTlsContextFactory.getKeyStoreConfiguration()).thenReturn((Object)this.mockKeyStoreConfig);
        Mockito.when((Object)this.mockTlsContextFactory.getTrustStoreConfiguration()).thenReturn((Object)this.mockTrustStoreConfig);
        Mockito.when((Object)this.mockKeyStoreConfig.getPath()).thenReturn((Object)"/path/to/keystore.jks");
        Mockito.when((Object)this.mockKeyStoreConfig.getType()).thenReturn((Object)"JKS");
        Mockito.when((Object)this.mockKeyStoreConfig.getPassword()).thenReturn((Object)"keystorePassword");
        Mockito.when((Object)this.mockTrustStoreConfig.getPath()).thenReturn((Object)"/path/to/truststore.jks");
        Mockito.when((Object)this.mockTrustStoreConfig.getType()).thenReturn((Object)"JKS");
        Mockito.when((Object)this.mockTrustStoreConfig.getPassword()).thenReturn((Object)"truststorePassword");
        EnhydraWrapperUtils.setTLSProperties((Properties)prop, (TlsContextFactory)this.mockTlsContextFactory);
        Assert.assertEquals((Object)"/path/to/keystore.jks", (Object)prop.getProperty("javax.net.ssl.keyStore"));
        Assert.assertEquals((Object)"JKS", (Object)prop.getProperty("javax.net.ssl.keyStoreType"));
        Assert.assertEquals((Object)"keystorePassword", (Object)prop.getProperty("javax.net.ssl.keyStorePassword"));
        Assert.assertEquals((Object)"/path/to/truststore.jks", (Object)prop.getProperty("javax.net.ssl.trustStore"));
        Assert.assertEquals((Object)"JKS", (Object)prop.getProperty("javax.net.ssl.trustStoreType"));
        Assert.assertEquals((Object)"truststorePassword", (Object)prop.getProperty("javax.net.ssl.trustStorePassword"));
    }

    @Test
    public void testSetTLSPropertiesWithEmptyKeyStoreConfiguration() {
        Properties prop = new Properties();
        Mockito.when((Object)this.mockTlsContextFactory.isKeyStoreConfigured()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTlsContextFactory.getKeyStoreConfiguration()).thenReturn((Object)this.mockKeyStoreConfig);
        Mockito.when((Object)this.mockKeyStoreConfig.getPath()).thenReturn((Object)"");
        Mockito.when((Object)this.mockKeyStoreConfig.getType()).thenReturn((Object)"");
        Mockito.when((Object)this.mockKeyStoreConfig.getPassword()).thenReturn((Object)"");
        EnhydraWrapperUtils.setTLSProperties((Properties)prop, (TlsContextFactory)this.mockTlsContextFactory);
        Assert.assertNull((Object)prop.getProperty("javax.net.ssl.keyStore"));
        Assert.assertNull((Object)prop.getProperty("javax.net.ssl.keyStoreType"));
        Assert.assertNull((Object)prop.getProperty("javax.net.ssl.keyStorePassword"));
    }

    @Test
    public void testSetTLSPropertiesWithEmptyTrustStoreConfiguration() {
        Properties prop = new Properties();
        Mockito.when((Object)this.mockTlsContextFactory.isTrustStoreConfigured()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTlsContextFactory.getTrustStoreConfiguration()).thenReturn((Object)this.mockTrustStoreConfig);
        Mockito.when((Object)this.mockTrustStoreConfig.getPath()).thenReturn((Object)"");
        Mockito.when((Object)this.mockTrustStoreConfig.getType()).thenReturn((Object)"");
        Mockito.when((Object)this.mockTrustStoreConfig.getPassword()).thenReturn((Object)"");
        EnhydraWrapperUtils.setTLSProperties((Properties)prop, (TlsContextFactory)this.mockTlsContextFactory);
        Assert.assertNull((Object)prop.getProperty("javax.net.ssl.trustStore"));
        Assert.assertNull((Object)prop.getProperty("javax.net.ssl.trustStoreType"));
        Assert.assertNull((Object)prop.getProperty("javax.net.ssl.trustStorePassword"));
    }

    @Test
    public void testSetTLSPropertiesPreservesExistingProperties() {
        Properties prop = new Properties();
        prop.setProperty("existing.property", "existing.value");
        Mockito.when((Object)this.mockTlsContextFactory.isKeyStoreConfigured()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTlsContextFactory.getKeyStoreConfiguration()).thenReturn((Object)this.mockKeyStoreConfig);
        Mockito.when((Object)this.mockKeyStoreConfig.getPath()).thenReturn((Object)"/path/to/keystore.jks");
        Mockito.when((Object)this.mockKeyStoreConfig.getType()).thenReturn((Object)"JKS");
        Mockito.when((Object)this.mockKeyStoreConfig.getPassword()).thenReturn((Object)"keystorePassword");
        EnhydraWrapperUtils.setTLSProperties((Properties)prop, (TlsContextFactory)this.mockTlsContextFactory);
        Assert.assertEquals((Object)"existing.value", (Object)prop.getProperty("existing.property"));
        Assert.assertEquals((Object)"/path/to/keystore.jks", (Object)prop.getProperty("javax.net.ssl.keyStore"));
        Assert.assertEquals((Object)"JKS", (Object)prop.getProperty("javax.net.ssl.keyStoreType"));
        Assert.assertEquals((Object)"keystorePassword", (Object)prop.getProperty("javax.net.ssl.keyStorePassword"));
    }

    @Test
    public void testSetTLSPropertiesWithDifferentKeyStoreTypes() {
        Properties prop = new Properties();
        Mockito.when((Object)this.mockTlsContextFactory.isKeyStoreConfigured()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTlsContextFactory.getKeyStoreConfiguration()).thenReturn((Object)this.mockKeyStoreConfig);
        Mockito.when((Object)this.mockKeyStoreConfig.getPath()).thenReturn((Object)"/path/to/keystore.p12");
        Mockito.when((Object)this.mockKeyStoreConfig.getType()).thenReturn((Object)"PKCS12");
        Mockito.when((Object)this.mockKeyStoreConfig.getPassword()).thenReturn((Object)"keystorePassword");
        EnhydraWrapperUtils.setTLSProperties((Properties)prop, (TlsContextFactory)this.mockTlsContextFactory);
        Assert.assertEquals((Object)"/path/to/keystore.p12", (Object)prop.getProperty("javax.net.ssl.keyStore"));
        Assert.assertEquals((Object)"PKCS12", (Object)prop.getProperty("javax.net.ssl.keyStoreType"));
        Assert.assertEquals((Object)"keystorePassword", (Object)prop.getProperty("javax.net.ssl.keyStorePassword"));
    }

    @Test
    public void testSetTLSPropertiesWithKeyStoreNotConfigured() {
        Properties prop = new Properties();
        Mockito.when((Object)this.mockTlsContextFactory.isKeyStoreConfigured()).thenReturn((Object)false);
        EnhydraWrapperUtils.setTLSProperties((Properties)prop, (TlsContextFactory)this.mockTlsContextFactory);
        Assert.assertNull((Object)prop.getProperty("javax.net.ssl.keyStore"));
        Assert.assertNull((Object)prop.getProperty("javax.net.ssl.keyStoreType"));
        Assert.assertNull((Object)prop.getProperty("javax.net.ssl.keyStorePassword"));
    }

    @Test
    public void testSetTLSPropertiesWithTrustStoreNotConfigured() {
        Properties prop = new Properties();
        Mockito.when((Object)this.mockTlsContextFactory.isTrustStoreConfigured()).thenReturn((Object)false);
        EnhydraWrapperUtils.setTLSProperties((Properties)prop, (TlsContextFactory)this.mockTlsContextFactory);
        Assert.assertNull((Object)prop.getProperty("javax.net.ssl.trustStore"));
        Assert.assertNull((Object)prop.getProperty("javax.net.ssl.trustStoreType"));
        Assert.assertNull((Object)prop.getProperty("javax.net.ssl.trustStorePassword"));
    }

    @Test
    public void testSetTLSPropertiesWithPartialKeyStoreConfiguration() {
        Properties prop = new Properties();
        Mockito.when((Object)this.mockTlsContextFactory.isKeyStoreConfigured()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTlsContextFactory.getKeyStoreConfiguration()).thenReturn((Object)this.mockKeyStoreConfig);
        Mockito.when((Object)this.mockKeyStoreConfig.getPath()).thenReturn((Object)"/path/to/keystore.jks");
        Mockito.when((Object)this.mockKeyStoreConfig.getType()).thenReturn((Object)"");
        Mockito.when((Object)this.mockKeyStoreConfig.getPassword()).thenReturn((Object)"keystorePassword");
        EnhydraWrapperUtils.setTLSProperties((Properties)prop, (TlsContextFactory)this.mockTlsContextFactory);
        Assert.assertEquals((Object)"/path/to/keystore.jks", (Object)prop.getProperty("javax.net.ssl.keyStore"));
        Assert.assertNull((Object)prop.getProperty("javax.net.ssl.keyStoreType"));
        Assert.assertEquals((Object)"keystorePassword", (Object)prop.getProperty("javax.net.ssl.keyStorePassword"));
    }

    @Test
    public void testSetTLSPropertiesWithPartialTrustStoreConfiguration() {
        Properties prop = new Properties();
        Mockito.when((Object)this.mockTlsContextFactory.isTrustStoreConfigured()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTlsContextFactory.getTrustStoreConfiguration()).thenReturn((Object)this.mockTrustStoreConfig);
        Mockito.when((Object)this.mockTrustStoreConfig.getPath()).thenReturn((Object)"/path/to/truststore.jks");
        Mockito.when((Object)this.mockTrustStoreConfig.getType()).thenReturn((Object)"JKS");
        Mockito.when((Object)this.mockTrustStoreConfig.getPassword()).thenReturn((Object)"");
        EnhydraWrapperUtils.setTLSProperties((Properties)prop, (TlsContextFactory)this.mockTlsContextFactory);
        Assert.assertEquals((Object)"/path/to/truststore.jks", (Object)prop.getProperty("javax.net.ssl.trustStore"));
        Assert.assertEquals((Object)"JKS", (Object)prop.getProperty("javax.net.ssl.trustStoreType"));
        Assert.assertNull((Object)prop.getProperty("javax.net.ssl.trustStorePassword"));
    }

    @Test
    public void testClassHasCorrectPackage() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.connection.enhydra.wrappers", (Object)EnhydraWrapperUtils.class.getPackage().getName());
    }

    @Test
    public void testClassHasCorrectName() {
        Assert.assertEquals((Object)"EnhydraWrapperUtils", (Object)EnhydraWrapperUtils.class.getSimpleName());
    }

    @Test
    public void testClassIsFinal() {
        Assert.assertTrue((boolean)Modifier.isFinal(EnhydraWrapperUtils.class.getModifiers()));
    }

    @Test
    public void testClassHasPrivateConstructor() throws Exception {
        Constructor constructor = EnhydraWrapperUtils.class.getDeclaredConstructor(new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPrivate(constructor.getModifiers()));
    }
}

