/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection.enhydra.wrappers;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.connection.enhydra.wrappers.StandardXADataSourceWrapper;
import org.mule.runtime.api.tls.TlsContextFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class StandardXADataSourceWrapperTestCase {
    @Mock
    private TlsContextFactory mockTlsContextFactory;
    @Mock
    private Connection mockConnection;

    @Test
    public void testConstructorWithTlsContextFactory() {
        StandardXADataSourceWrapper wrapper = new StandardXADataSourceWrapper(this.mockTlsContextFactory);
        Assert.assertNotNull((Object)wrapper);
        Assert.assertTrue((boolean)(wrapper instanceof StandardXADataSourceWrapper));
    }

    @Test
    public void testConstructorWithNullTlsContextFactory() {
        StandardXADataSourceWrapper wrapper = new StandardXADataSourceWrapper(null);
        Assert.assertNotNull((Object)wrapper);
        Assert.assertTrue((boolean)(wrapper instanceof StandardXADataSourceWrapper));
    }

    @Test
    public void testGetConnectionWithUserAndPassword() throws SQLException {
        StandardXADataSourceWrapper wrapper = new StandardXADataSourceWrapper(this.mockTlsContextFactory);
        String user = "testUser";
        String password = "testPassword";
        try {
            Connection connection = wrapper.getConnection(user, password);
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetConnectionWithNullCredentials() throws SQLException {
        StandardXADataSourceWrapper wrapper = new StandardXADataSourceWrapper(this.mockTlsContextFactory);
        try {
            Connection connection = wrapper.getConnection(null, null);
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetConnectionWithEmptyCredentials() throws SQLException {
        StandardXADataSourceWrapper wrapper = new StandardXADataSourceWrapper(this.mockTlsContextFactory);
        try {
            Connection connection = wrapper.getConnection("", "");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetConnectionWithNullTlsContextFactory() throws SQLException {
        StandardXADataSourceWrapper wrapper = new StandardXADataSourceWrapper(null);
        try {
            Connection connection = wrapper.getConnection("user", "password");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testClassHasCorrectPackage() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.connection.enhydra.wrappers", (Object)StandardXADataSourceWrapper.class.getPackage().getName());
    }

    @Test
    public void testClassHasCorrectName() {
        Assert.assertEquals((Object)"StandardXADataSourceWrapper", (Object)StandardXADataSourceWrapper.class.getSimpleName());
    }

    @Test
    public void testClassExtendsStandardXADataSource() {
        Assert.assertTrue((boolean)StandardXADataSourceWrapper.class.getSuperclass().equals(StandardXADataSource.class));
    }

    @Test
    public void testGetConnectionMethodIsSynchronized() throws Exception {
        Method getConnectionMethod = StandardXADataSourceWrapper.class.getDeclaredMethod("getConnection", String.class, String.class);
        Assert.assertTrue((boolean)Modifier.isSynchronized(getConnectionMethod.getModifiers()));
    }

    @Test
    public void testGetConnectionMethodThrowsSQLException() throws Exception {
        Method getConnectionMethod = StandardXADataSourceWrapper.class.getDeclaredMethod("getConnection", String.class, String.class);
        Class<?>[] exceptionTypes = getConnectionMethod.getExceptionTypes();
        boolean throwsSQLException = false;
        for (Class<?> exceptionType : exceptionTypes) {
            if (!exceptionType.equals(SQLException.class)) continue;
            throwsSQLException = true;
            break;
        }
        Assert.assertTrue((String)"getConnection method should throw SQLException", (boolean)throwsSQLException);
    }

    @Test
    public void testGetConnectionMethodReturnsConnection() throws Exception {
        Method getConnectionMethod = StandardXADataSourceWrapper.class.getDeclaredMethod("getConnection", String.class, String.class);
        Assert.assertEquals(Connection.class, getConnectionMethod.getReturnType());
    }

    @Test
    public void testGetConnectionMethodParameters() throws Exception {
        Method getConnectionMethod = StandardXADataSourceWrapper.class.getDeclaredMethod("getConnection", String.class, String.class);
        Class<?>[] parameterTypes = getConnectionMethod.getParameterTypes();
        Assert.assertEquals((long)2L, (long)parameterTypes.length);
        Assert.assertEquals(String.class, parameterTypes[0]);
        Assert.assertEquals(String.class, parameterTypes[1]);
    }

    @Test
    public void testClassImportsEnhydraWrapperUtils() {
        Assert.assertTrue((String)"Class should be in the correct package", (boolean)StandardXADataSourceWrapper.class.getPackage().getName().equals("org.mule.db.commons.internal.domain.connection.enhydra.wrappers"));
    }

    @Test
    public void testClassImportsClassUtils() {
        Assert.assertTrue((String)"Class should extend StandardXADataSource", (boolean)StandardXADataSourceWrapper.class.getSuperclass().equals(StandardXADataSource.class));
    }
}

