/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection.generic;

import java.lang.reflect.Field;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.db.commons.api.param.TransactionIsolation;
import org.mule.db.commons.internal.domain.connection.DataSourceConfig;
import org.mule.db.commons.internal.domain.connection.generic.GenericConnectionParameters;
import org.mule.db.commons.internal.domain.connection.generic.GenericConnectionProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class GenericConnectionProviderTestCase
extends AbstractMuleTestCase {
    private GenericConnectionProvider provider;
    private GenericConnectionParameters parameters;

    @Before
    public void setUp() {
        this.provider = new GenericConnectionProvider();
        this.parameters = new GenericConnectionParameters();
    }

    @Test
    public void testGetDataSourceReturnsEmpty() {
        Optional dataSource = this.provider.getDataSource();
        MatcherAssert.assertThat((Object)dataSource, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertFalse((boolean)dataSource.isPresent());
    }

    @Test
    public void testGetDataSourceConfigReturnsEmptyWhenNoParameters() {
        Optional config = this.provider.getDataSourceConfig();
        MatcherAssert.assertThat((Object)config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertFalse((boolean)config.isPresent());
    }

    @Test
    public void testGetDataSourceConfigReturnsParametersWhenSet() throws Exception {
        this.setField(this.provider, "genericConnectionParameters", this.parameters);
        Optional config = this.provider.getDataSourceConfig();
        MatcherAssert.assertThat((Object)config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)config.isPresent());
        Assert.assertEquals((Object)this.parameters, config.get());
    }

    @Test
    public void testGetDataSourceConfigReturnsNullWhenParametersIsNull() throws Exception {
        this.setField(this.provider, "genericConnectionParameters", null);
        Optional config = this.provider.getDataSourceConfig();
        MatcherAssert.assertThat((Object)config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertFalse((boolean)config.isPresent());
    }

    @Test
    public void testProviderInheritance() {
        MatcherAssert.assertThat((Object)this.provider, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)(this.provider instanceof GenericConnectionProvider));
    }

    @Test
    public void testParametersInheritance() {
        MatcherAssert.assertThat((Object)this.parameters, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)(this.parameters instanceof GenericConnectionParameters));
        Assert.assertTrue((boolean)(this.parameters instanceof DataSourceConfig));
    }

    @Test
    public void testDefaultParameterValues() {
        Assert.assertEquals((Object)TransactionIsolation.NOT_CONFIGURED, (Object)this.parameters.getTransactionIsolation());
        Assert.assertFalse((boolean)this.parameters.isUseXaTransactions());
        Assert.assertEquals(null, (Object)this.parameters.getUrl());
        Assert.assertEquals(null, (Object)this.parameters.getDriverClassName());
        Assert.assertEquals(null, (Object)this.parameters.getUser());
        Assert.assertEquals(null, (Object)this.parameters.getPassword());
    }

    @Test
    public void testParameterGetters() throws Exception {
        this.setField(this.parameters, "url", "jdbc:test://localhost/test");
        this.setField(this.parameters, "driverClassName", "com.test.Driver");
        this.setField(this.parameters, "user", "testuser");
        this.setField(this.parameters, "password", "testpass");
        Assert.assertEquals((Object)"jdbc:test://localhost/test", (Object)this.parameters.getUrl());
        Assert.assertEquals((Object)"com.test.Driver", (Object)this.parameters.getDriverClassName());
        Assert.assertEquals((Object)"testuser", (Object)this.parameters.getUser());
        Assert.assertEquals((Object)"testpass", (Object)this.parameters.getPassword());
    }

    private void setField(Object target, String fieldName, Object value) throws Exception {
        Field field = target.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(target, value);
    }
}

