/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection.type.resolver;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.internal.domain.connection.DefaultDbConnection;
import org.mule.db.commons.internal.domain.connection.type.resolver.ArrayTypeResolver;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;

@RunWith(value=MockitoJUnitRunner.class)
public class ArrayTypeResolverTestCase {
    @Mock
    private DefaultDbConnection mockConnection;
    @Mock
    private PreparedStatement mockPreparedStatement;
    @Mock
    private ResultSet mockResultSet;
    @Mock
    private Struct mockStruct;
    @Mock
    private ResolvedDbType mockResolvedDbType;
    private ArrayTypeResolver arrayTypeResolver;

    @Before
    public void setUp() throws Exception {
        this.arrayTypeResolver = new ArrayTypeResolver(this.mockConnection);
        Mockito.when((Object)this.mockConnection.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)this.mockPreparedStatement);
        Mockito.when((Object)this.mockPreparedStatement.executeQuery()).thenReturn((Object)this.mockResultSet);
        Mockito.when((Object)this.mockResolvedDbType.getId()).thenReturn((Object)1);
        Mockito.when((Object)this.mockResolvedDbType.getName()).thenReturn((Object)"TEST_TYPE");
    }

    @Test
    public void testConstructor() {
        ArrayTypeResolver resolver = new ArrayTypeResolver(this.mockConnection);
        Assert.assertNotNull((Object)resolver);
    }

    @Test
    public void testResolveTypeWithSimpleTypeName() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)this.mockResultSet.getString("ELEM_TYPE_NAME")).thenReturn((Object)"RESOLVED_TYPE");
        String result = this.arrayTypeResolver.resolveType("SIMPLE_TYPE");
        Assert.assertEquals((Object)"RESOLVED_TYPE", (Object)result);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).prepareStatement((String)ArgumentMatchers.eq((Object)"SELECT * FROM SYS.ALL_COLL_TYPES WHERE TYPE_NAME = ?"));
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setString(ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq((Object)"SIMPLE_TYPE"));
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement, (VerificationMode)Mockito.never())).setString(ArgumentMatchers.eq((int)2), ArgumentMatchers.anyString());
    }

    @Test
    public void testResolveTypeWithOwnerTypeName() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)this.mockResultSet.getString("ELEM_TYPE_NAME")).thenReturn((Object)"RESOLVED_TYPE");
        String result = this.arrayTypeResolver.resolveType("OWNER.COMPLEX_TYPE");
        Assert.assertEquals((Object)"RESOLVED_TYPE", (Object)result);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).prepareStatement((String)ArgumentMatchers.eq((Object)"SELECT * FROM SYS.ALL_COLL_TYPES WHERE TYPE_NAME = ? AND OWNER = ?"));
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setString(ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq((Object)"COMPLEX_TYPE"));
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setString(ArgumentMatchers.eq((int)2), (String)ArgumentMatchers.eq((Object)"OWNER"));
    }

    @Test
    public void testResolveTypeWithNoResult() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)false);
        String result = this.arrayTypeResolver.resolveType("NON_EXISTENT_TYPE");
        Assert.assertEquals((Object)"NON_EXISTENT_TYPE", (Object)result);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).prepareStatement((String)ArgumentMatchers.eq((Object)"SELECT * FROM SYS.ALL_COLL_TYPES WHERE TYPE_NAME = ?"));
    }

    @Test
    public void testResolveTypeWithMultipleResults() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)this.mockResultSet.getString("ELEM_TYPE_NAME")).thenReturn((Object)"FIRST_TYPE", (Object[])new String[]{"LAST_TYPE"});
        String result = this.arrayTypeResolver.resolveType("MULTI_RESULT_TYPE");
        Assert.assertEquals((Object)"LAST_TYPE", (Object)result);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).prepareStatement((String)ArgumentMatchers.eq((Object)"SELECT * FROM SYS.ALL_COLL_TYPES WHERE TYPE_NAME = ?"));
    }

    @Test
    public void testResolveTypeWithSQLException() throws SQLException {
        Mockito.when((Object)this.mockConnection.prepareStatement(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new SQLException("Database error")});
        Assert.assertThrows(SQLException.class, () -> this.arrayTypeResolver.resolveType("ERROR_TYPE"));
    }

    @Test
    public void testResolveTypeWithCache() throws SQLException {
        ConcurrentHashMap<String, String> typeCache = new ConcurrentHashMap<String, String>();
        typeCache.put("CACHED_TYPE", "CACHED_RESULT");
        String result = this.arrayTypeResolver.resolveType("CACHED_TYPE", typeCache);
        Assert.assertEquals((Object)"CACHED_RESULT", (Object)result);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).prepareStatement(ArgumentMatchers.anyString());
    }

    @Test
    public void testResolveTypeWithCacheMiss() throws SQLException {
        ConcurrentHashMap typeCache = new ConcurrentHashMap();
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)this.mockResultSet.getString("ELEM_TYPE_NAME")).thenReturn((Object)"NEW_RESULT");
        String result = this.arrayTypeResolver.resolveType("NEW_TYPE", typeCache);
        Assert.assertEquals((Object)"NEW_RESULT", (Object)result);
        Assert.assertEquals((Object)"NEW_RESULT", typeCache.get("NEW_TYPE"));
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).prepareStatement((String)ArgumentMatchers.eq((Object)"SELECT * FROM SYS.ALL_COLL_TYPES WHERE TYPE_NAME = ?"));
    }

    @Test
    public void testResolveLobsWithStructElements() throws SQLException {
        Object[] elements = new Object[]{this.mockStruct, this.mockStruct};
        this.arrayTypeResolver.resolveLobs(elements, Integer.valueOf(1), "STRUCT_TYPE");
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).doResolveLobIn((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
    }

    @Test
    public void testResolveLobsWithCollectionElements() throws SQLException {
        List<String> list1 = Arrays.asList("item1", "item2");
        List<String> list2 = Arrays.asList("item3", "item4");
        Object[] elements = new Object[]{list1, list2};
        this.arrayTypeResolver.resolveLobs(elements, Integer.valueOf(1), "COLLECTION_TYPE");
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.times((int)2))).doResolveLobIn((Object[])ArgumentMatchers.any(Object[].class), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq((Object)"COLLECTION_TYPE"));
        Assert.assertTrue((boolean)(elements[0] instanceof Object[]));
        Assert.assertTrue((boolean)(elements[1] instanceof Object[]));
    }

    @Test
    public void testResolveLobsWithIterableElements() throws SQLException {
        List<String> iterable1 = Arrays.asList("item1", "item2");
        List<String> iterable2 = Arrays.asList("item3", "item4");
        Object[] elements = new Object[]{iterable1, iterable2};
        this.arrayTypeResolver.resolveLobs(elements, Integer.valueOf(2), "ITERABLE_TYPE");
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.times((int)2))).doResolveLobIn((Object[])ArgumentMatchers.any(Object[].class), ArgumentMatchers.eq((int)2), (String)ArgumentMatchers.eq((Object)"ITERABLE_TYPE"));
        Assert.assertTrue((boolean)(elements[0] instanceof Object[]));
        Assert.assertTrue((boolean)(elements[1] instanceof Object[]));
    }

    @Test
    public void testResolveLobsWithObjectArrayElements() throws SQLException {
        Object[] array1 = new Object[]{"item1", "item2"};
        Object[] array2 = new Object[]{"item3", "item4"};
        Object[] elements = new Object[]{array1, array2};
        this.arrayTypeResolver.resolveLobs(elements, Integer.valueOf(3), "ARRAY_TYPE");
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.times((int)2))).doResolveLobIn((Object[])ArgumentMatchers.any(Object[].class), ArgumentMatchers.eq((int)3), (String)ArgumentMatchers.eq((Object)"ARRAY_TYPE"));
    }

    @Test
    public void testResolveLobsWithUnsupportedElementType() {
        Object[] elements = new Object[]{"string", 123, new Object()};
        Assert.assertThrows(RuntimeException.class, () -> this.arrayTypeResolver.resolveLobs(elements, Integer.valueOf(1), "UNSUPPORTED_TYPE"));
    }

    @Test
    public void testResolveLobsWithEmptyArray() throws SQLException {
        Object[] elements = new Object[]{};
        this.arrayTypeResolver.resolveLobs(elements, Integer.valueOf(1), "EMPTY_TYPE");
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).doResolveLobIn((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
    }

    @Test
    public void testResolveLobIn() throws SQLException {
        Object[] attributes = new Object[]{new Object[]{"attr1", "attr2"}, new Object[]{"attr3", "attr4"}};
        this.arrayTypeResolver.resolveLobIn(attributes, Integer.valueOf(1), this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.times((int)2))).doResolveLobIn((Object[])ArgumentMatchers.any(Object[].class), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq((Object)"TEST_TYPE"));
    }

    @Test
    public void testResolveLobInWithEmptyAttributes() throws SQLException {
        Object[] attributes = new Object[]{};
        this.arrayTypeResolver.resolveLobIn(attributes, Integer.valueOf(1), this.mockResolvedDbType);
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).doResolveLobIn((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
    }

    @Test
    public void testResolveLobInWithSQLException() throws SQLException {
        Object[] attributes = new Object[]{new Object[]{"attr1"}};
        ((DefaultDbConnection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("Database error")}).when((Object)this.mockConnection)).doResolveLobIn((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
        Assert.assertThrows(SQLException.class, () -> this.arrayTypeResolver.resolveLobIn(attributes, Integer.valueOf(1), this.mockResolvedDbType));
    }

    @Test
    public void testGetOwnerFromWithOwner() {
        String typeName = "SCHEMA.TABLE_NAME";
        Optional result = ArrayTypeResolver.getOwnerFrom((String)typeName);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"SCHEMA", result.get());
    }

    @Test
    public void testGetOwnerFromWithoutOwner() {
        String typeName = "TABLE_NAME";
        Optional result = ArrayTypeResolver.getOwnerFrom((String)typeName);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetOwnerFromWithMultipleDots() {
        String typeName = "SCHEMA.TABLE.COLUMN";
        Optional result = ArrayTypeResolver.getOwnerFrom((String)typeName);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"SCHEMA", result.get());
    }

    @Test
    public void testGetOwnerFromWithEmptyString() {
        String typeName = "";
        Optional result = ArrayTypeResolver.getOwnerFrom((String)typeName);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetTypeSimpleNameWithOwner() {
        String typeName = "SCHEMA.TABLE_NAME";
        String result = ArrayTypeResolver.getTypeSimpleName((String)typeName);
        Assert.assertEquals((Object)"TABLE_NAME", (Object)result);
    }

    @Test
    public void testGetTypeSimpleNameWithoutOwner() {
        String typeName = "TABLE_NAME";
        String result = ArrayTypeResolver.getTypeSimpleName((String)typeName);
        Assert.assertEquals((Object)"TABLE_NAME", (Object)result);
    }

    @Test
    public void testGetTypeSimpleNameWithMultipleDots() {
        String typeName = "SCHEMA.TABLE.COLUMN";
        String result = ArrayTypeResolver.getTypeSimpleName((String)typeName);
        Assert.assertEquals((Object)"TABLE.COLUMN", (Object)result);
    }

    @Test
    public void testGetTypeSimpleNameWithEmptyString() {
        String typeName = "";
        String result = ArrayTypeResolver.getTypeSimpleName((String)typeName);
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testGetTypeSimpleNameWithOnlyDot() {
        String typeName = ".";
        String result = ArrayTypeResolver.getTypeSimpleName((String)typeName);
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testResolveLobsWithMixedElementTypes() throws SQLException {
        List<String> list = Arrays.asList("item1", "item2");
        Object[] array = new Object[]{"item3", "item4"};
        Object[] elements = new Object[]{this.mockStruct, list, array};
        this.arrayTypeResolver.resolveLobs(elements, Integer.valueOf(1), "MIXED_TYPE");
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.times((int)2))).doResolveLobIn((Object[])ArgumentMatchers.any(Object[].class), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq((Object)"MIXED_TYPE"));
        Assert.assertTrue((boolean)(elements[1] instanceof Object[]));
        Assert.assertTrue((boolean)(elements[2] instanceof Object[]));
    }

    @Test
    public void testResolveLobsWithNullElements() throws SQLException {
        Object[] elements = new Object[]{null, "string", null};
        Assert.assertThrows(RuntimeException.class, () -> this.arrayTypeResolver.resolveLobs(elements, Integer.valueOf(1), "NULL_TYPE"));
    }

    @Test
    public void testResolveLobInWithNullAttributes() throws SQLException {
        Assert.assertThrows(NullPointerException.class, () -> this.arrayTypeResolver.resolveLobIn(null, Integer.valueOf(1), this.mockResolvedDbType));
    }

    @Test
    public void testResolveLobInWithNullResolvedDbType() throws SQLException {
        Object[] attributes = new Object[]{new Object[]{"attr1"}};
        Assert.assertThrows(NullPointerException.class, () -> this.arrayTypeResolver.resolveLobIn(attributes, Integer.valueOf(1), null));
    }

    @Test
    public void testResolveLobsWithSQLExceptionInConnection() throws SQLException {
        Object[] elements = new Object[]{new Object[]{"item1"}};
        ((DefaultDbConnection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("Connection error")}).when((Object)this.mockConnection)).doResolveLobIn((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
        Assert.assertThrows(SQLException.class, () -> this.arrayTypeResolver.resolveLobs(elements, Integer.valueOf(1), "ERROR_TYPE"));
    }

    @Test
    public void testResolveTypeWithDatabaseConnectionError() throws SQLException {
        Mockito.when((Object)this.mockPreparedStatement.executeQuery()).thenThrow(new Throwable[]{new SQLException("Connection error")});
        Assert.assertThrows(SQLException.class, () -> this.arrayTypeResolver.resolveType("ERROR_TYPE"));
    }

    @Test
    public void testResolveTypeWithResultSetError() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenThrow(new Throwable[]{new SQLException("ResultSet error")});
        Assert.assertThrows(SQLException.class, () -> this.arrayTypeResolver.resolveType("ERROR_TYPE"));
    }

    @Test
    public void testResolveTypeWithPreparedStatementError() throws SQLException {
        ((PreparedStatement)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("PreparedStatement error")}).when((Object)this.mockPreparedStatement)).setString(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
        Assert.assertThrows(SQLException.class, () -> this.arrayTypeResolver.resolveType("ERROR_TYPE"));
    }

    @Test
    public void testResolveLobsWithComplexCollection() throws SQLException {
        List<List> nestedList = Arrays.asList(Arrays.asList("nested1", "nested2"), Arrays.asList("nested3", "nested4"));
        Object[] elements = new Object[]{nestedList};
        this.arrayTypeResolver.resolveLobs(elements, Integer.valueOf(1), "NESTED_TYPE");
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn((Object[])ArgumentMatchers.any(Object[].class), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq((Object)"NESTED_TYPE"));
        Assert.assertTrue((boolean)(elements[0] instanceof Object[]));
    }

    @Test
    public void testResolveLobsWithArrayList() throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("item1");
        arrayList.add("item2");
        Object[] elements = new Object[]{arrayList};
        this.arrayTypeResolver.resolveLobs(elements, Integer.valueOf(1), "ARRAYLIST_TYPE");
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn((Object[])ArgumentMatchers.any(Object[].class), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq((Object)"ARRAYLIST_TYPE"));
        Assert.assertTrue((boolean)(elements[0] instanceof Object[]));
    }

    @Test
    public void testResolveLobsWithEmptyCollection() throws SQLException {
        ArrayList emptyList = new ArrayList();
        Object[] elements = new Object[]{emptyList};
        this.arrayTypeResolver.resolveLobs(elements, Integer.valueOf(1), "EMPTY_COLLECTION_TYPE");
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn((Object[])ArgumentMatchers.any(Object[].class), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq((Object)"EMPTY_COLLECTION_TYPE"));
        Assert.assertTrue((boolean)(elements[0] instanceof Object[]));
        Assert.assertEquals((long)0L, (long)((Object[])elements[0]).length);
    }

    @Test
    public void testResolveLobsWithEmptyObjectArray() throws SQLException {
        Object[] emptyArray = new Object[]{};
        Object[] elements = new Object[]{emptyArray};
        this.arrayTypeResolver.resolveLobs(elements, Integer.valueOf(1), "EMPTY_ARRAY_TYPE");
        ((DefaultDbConnection)Mockito.verify((Object)this.mockConnection)).doResolveLobIn((Object[])ArgumentMatchers.any(Object[].class), ArgumentMatchers.eq((int)1), (String)ArgumentMatchers.eq((Object)"EMPTY_ARRAY_TYPE"));
    }
}

