/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.logger;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.logger.AbstractNullQueryLogger;
import org.mule.db.commons.internal.domain.logger.NullSingleQueryLogger;
import org.mule.db.commons.internal.domain.logger.QueryLogger;
import org.mule.db.commons.internal.domain.logger.SingleQueryLogger;
import org.mule.db.commons.internal.domain.param.DefaultInputQueryParam;
import org.mule.db.commons.internal.domain.param.InputQueryParam;
import org.mule.db.commons.internal.domain.type.UnknownDbType;

@RunWith(value=MockitoJUnitRunner.class)
public class NullSingleQueryLoggerTestCase {
    @Mock
    private InputQueryParam mockParam;
    private NullSingleQueryLogger logger;

    @Before
    public void setUp() {
        this.logger = new NullSingleQueryLogger();
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.logger);
    }

    @Test
    public void testLogQuery() {
        this.logger.logQuery();
    }

    @Test
    public void testAddParameterWithNullParam() {
        this.logger.addParameter(null, (Object)"testValue");
    }

    @Test
    public void testAddParameterWithNullValue() {
        this.logger.addParameter(this.mockParam, null);
    }

    @Test
    public void testAddParameterWithValidParamAndValue() {
        this.logger.addParameter(this.mockParam, (Object)"testValue");
    }

    @Test
    public void testAddParameterWithConcreteParam() {
        DefaultInputQueryParam concreteParam = new DefaultInputQueryParam(1, UnknownDbType.getInstance(), (Object)"testValue", "paramName");
        this.logger.addParameter((InputQueryParam)concreteParam, (Object)"testValue");
    }

    @Test
    public void testMultipleLogQueryCalls() {
        this.logger.logQuery();
        this.logger.logQuery();
        this.logger.logQuery();
    }

    @Test
    public void testMultipleAddParameterCalls() {
        this.logger.addParameter(this.mockParam, (Object)"value1");
        this.logger.addParameter(this.mockParam, (Object)"value2");
        this.logger.addParameter(this.mockParam, (Object)"value3");
    }

    @Test
    public void testLoggerImplementsSingleQueryLogger() {
        Assert.assertTrue((boolean)(this.logger instanceof SingleQueryLogger));
    }

    @Test
    public void testLoggerImplementsQueryLogger() {
        Assert.assertTrue((boolean)(this.logger instanceof QueryLogger));
    }

    @Test
    public void testLoggerExtendsAbstractNullQueryLogger() {
        Assert.assertTrue((boolean)(this.logger instanceof AbstractNullQueryLogger));
    }

    @Test
    public void testLoggerPackage() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.logger", (Object)NullSingleQueryLogger.class.getPackage().getName());
    }

    @Test
    public void testLoggerClassName() {
        Assert.assertEquals((Object)"NullSingleQueryLogger", (Object)NullSingleQueryLogger.class.getSimpleName());
    }

    @Test
    public void testLoggerFullClassName() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.domain.logger.NullSingleQueryLogger", (Object)NullSingleQueryLogger.class.getName());
    }

    @Test
    public void testMultipleInstances() {
        NullSingleQueryLogger logger1 = new NullSingleQueryLogger();
        NullSingleQueryLogger logger2 = new NullSingleQueryLogger();
        Assert.assertNotNull((Object)logger1);
        Assert.assertNotNull((Object)logger2);
        Assert.assertNotSame((Object)logger1, (Object)logger2);
    }

    @Test
    public void testAddParameterWithDifferentValueTypes() {
        this.logger.addParameter(this.mockParam, (Object)"stringValue");
        this.logger.addParameter(this.mockParam, (Object)123);
        this.logger.addParameter(this.mockParam, (Object)123.45);
        this.logger.addParameter(this.mockParam, (Object)true);
        this.logger.addParameter(this.mockParam, new Object());
    }

    @Test
    public void testAddParameterWithEmptyString() {
        this.logger.addParameter(this.mockParam, (Object)"");
    }

    @Test
    public void testAddParameterWithSpecialCharacters() {
        this.logger.addParameter(this.mockParam, (Object)"special chars: !@#$%^&*()");
    }

    @Test
    public void testAddParameterWithUnicodeCharacters() {
        this.logger.addParameter(this.mockParam, (Object)"unicode: \u4f60\u597d\u4e16\u754c");
    }

    @Test
    public void testAddParameterWithVeryLongString() {
        StringBuilder longString = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            longString.append("very long string ");
        }
        this.logger.addParameter(this.mockParam, (Object)longString.toString());
    }
}

