/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.sql.CallableStatement;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.type.AbstractStructuredDbType;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.MappedStructResolvedDbType;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;

public class MappedStructResolvedDbTypeTestCase {
    private static final int TEST_ID = 2002;
    private static final String TEST_NAME = "TEST_STRUCT_TYPE";
    private MappedStructResolvedDbType<String> mappedStructDbType;
    private CallableStatement callableStatement;

    @Before
    public void setUp() throws Exception {
        this.mappedStructDbType = new MappedStructResolvedDbType(2002, TEST_NAME, String.class);
        this.callableStatement = (CallableStatement)Mockito.mock(CallableStatement.class);
    }

    @Test
    public void testConstructor() {
        Assert.assertEquals((long)2002L, (long)this.mappedStructDbType.getId());
        Assert.assertEquals((Object)TEST_NAME, (Object)this.mappedStructDbType.getName());
        Assert.assertEquals(String.class, (Object)this.mappedStructDbType.getMappedClass());
    }

    @Test
    public void testConstructorWithDifferentTypes() {
        MappedStructResolvedDbType intType = new MappedStructResolvedDbType(2002, "INT_STRUCT", Integer.class);
        Assert.assertEquals((long)2002L, (long)intType.getId());
        Assert.assertEquals((Object)"INT_STRUCT", (Object)intType.getName());
        Assert.assertEquals(Integer.class, (Object)intType.getMappedClass());
        MappedStructResolvedDbType objectType = new MappedStructResolvedDbType(2002, "OBJECT_STRUCT", Object.class);
        Assert.assertEquals((long)2002L, (long)objectType.getId());
        Assert.assertEquals((Object)"OBJECT_STRUCT", (Object)objectType.getName());
        Assert.assertEquals(Object.class, (Object)objectType.getMappedClass());
    }

    @Test
    public void testGetMappedClass() {
        Assert.assertEquals(String.class, (Object)this.mappedStructDbType.getMappedClass());
    }

    @Test
    public void testGetMappedClassWithDifferentTypes() {
        MappedStructResolvedDbType longType = new MappedStructResolvedDbType(2002, TEST_NAME, Long.class);
        Assert.assertEquals(Long.class, (Object)longType.getMappedClass());
        MappedStructResolvedDbType doubleType = new MappedStructResolvedDbType(2002, TEST_NAME, Double.class);
        Assert.assertEquals(Double.class, (Object)doubleType.getMappedClass());
    }

    @Test
    public void testGetParameterValue() throws SQLException {
        String expectedValue = "test_value";
        Mockito.when((Object)this.callableStatement.getObject(1)).thenReturn((Object)expectedValue);
        Object result = this.mappedStructDbType.getParameterValue(this.callableStatement, 1);
        Assert.assertEquals((Object)expectedValue, (Object)result);
        ((CallableStatement)Mockito.verify((Object)this.callableStatement)).getObject(1);
    }

    @Test
    public void testGetParameterValueWithDifferentIndex() throws SQLException {
        String expectedValue = "another_value";
        Mockito.when((Object)this.callableStatement.getObject(5)).thenReturn((Object)expectedValue);
        Object result = this.mappedStructDbType.getParameterValue(this.callableStatement, 5);
        Assert.assertEquals((Object)expectedValue, (Object)result);
        ((CallableStatement)Mockito.verify((Object)this.callableStatement)).getObject(5);
    }

    @Test
    public void testGetParameterValueWithNull() throws SQLException {
        Mockito.when((Object)this.callableStatement.getObject(1)).thenReturn(null);
        Object result = this.mappedStructDbType.getParameterValue(this.callableStatement, 1);
        Assert.assertNull((Object)result);
        ((CallableStatement)Mockito.verify((Object)this.callableStatement)).getObject(1);
    }

    @Test
    public void testGetParameterValueWithDifferentTypes() throws SQLException {
        MappedStructResolvedDbType intType = new MappedStructResolvedDbType(2002, TEST_NAME, Integer.class);
        Integer intValue = 42;
        Mockito.when((Object)this.callableStatement.getObject(1)).thenReturn((Object)intValue);
        Object result = intType.getParameterValue(this.callableStatement, 1);
        Assert.assertEquals((Object)intValue, (Object)result);
        ((CallableStatement)Mockito.verify((Object)this.callableStatement)).getObject(1);
        MappedStructResolvedDbType objectType = new MappedStructResolvedDbType(2002, TEST_NAME, Object.class);
        Object objectValue = new Object();
        Mockito.when((Object)this.callableStatement.getObject(2)).thenReturn(objectValue);
        Object result2 = objectType.getParameterValue(this.callableStatement, 2);
        Assert.assertEquals((Object)objectValue, (Object)result2);
        ((CallableStatement)Mockito.verify((Object)this.callableStatement)).getObject(2);
    }

    @Test
    public void testGetParameterValueWithSQLException() throws SQLException {
        Mockito.when((Object)this.callableStatement.getObject(1)).thenThrow(new Throwable[]{new SQLException("Database error")});
        try {
            this.mappedStructDbType.getParameterValue(this.callableStatement, 1);
            Assert.fail((String)"Expected SQLException");
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"Database error", (Object)e.getMessage());
        }
        ((CallableStatement)Mockito.verify((Object)this.callableStatement)).getObject(1);
    }

    @Test
    public void testInheritanceFromAbstractStructuredDbType() {
        Assert.assertTrue((boolean)(this.mappedStructDbType instanceof AbstractStructuredDbType));
        Assert.assertTrue((boolean)(this.mappedStructDbType instanceof ResolvedDbType));
        Assert.assertTrue((boolean)(this.mappedStructDbType instanceof DbType));
    }

    @Test
    public void testRegisterOutParameter() throws SQLException {
        this.mappedStructDbType.registerOutParameter(this.callableStatement, 1);
        ((CallableStatement)Mockito.verify((Object)this.callableStatement)).registerOutParameter(1, 2002, TEST_NAME);
    }

    @Test
    public void testRegisterOutParameterWithDifferentIndex() throws SQLException {
        this.mappedStructDbType.registerOutParameter(this.callableStatement, 3);
        ((CallableStatement)Mockito.verify((Object)this.callableStatement)).registerOutParameter(3, 2002, TEST_NAME);
    }

    @Test
    public void testRegisterOutParameterWithSQLException() throws SQLException {
        ((CallableStatement)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("Registration error")}).when((Object)this.callableStatement)).registerOutParameter(1, 2002, TEST_NAME);
        try {
            this.mappedStructDbType.registerOutParameter(this.callableStatement, 1);
            Assert.fail((String)"Expected SQLException");
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"Registration error", (Object)e.getMessage());
        }
        ((CallableStatement)Mockito.verify((Object)this.callableStatement)).registerOutParameter(1, 2002, TEST_NAME);
    }

    @Test
    public void testMultipleInstances() {
        MappedStructResolvedDbType type1 = new MappedStructResolvedDbType(2002, "TYPE_1", String.class);
        MappedStructResolvedDbType type2 = new MappedStructResolvedDbType(2002, "TYPE_2", Integer.class);
        Assert.assertEquals((Object)"TYPE_1", (Object)type1.getName());
        Assert.assertEquals((Object)"TYPE_2", (Object)type2.getName());
        Assert.assertEquals(String.class, (Object)type1.getMappedClass());
        Assert.assertEquals(Integer.class, (Object)type2.getMappedClass());
    }

    @Test
    public void testToString() {
        String toString = this.mappedStructDbType.toString();
        Assert.assertNotNull((Object)toString);
        Assert.assertFalse((boolean)toString.isEmpty());
    }

    @Test
    public void testEqualsAndHashCode() {
        MappedStructResolvedDbType type1 = new MappedStructResolvedDbType(2002, TEST_NAME, String.class);
        MappedStructResolvedDbType type2 = new MappedStructResolvedDbType(2002, TEST_NAME, String.class);
        MappedStructResolvedDbType type3 = new MappedStructResolvedDbType(2002, TEST_NAME, Integer.class);
        Assert.assertFalse((boolean)type1.equals(type2));
        Assert.assertFalse((boolean)type1.equals(type3));
        Assert.assertFalse((boolean)type1.equals(null));
        Assert.assertTrue((boolean)type1.equals(type1));
        Assert.assertNotEquals((long)type1.hashCode(), (long)type2.hashCode());
        Assert.assertNotEquals((long)type1.hashCode(), (long)type3.hashCode());
    }

    @Test
    public void testGenericTypeSafety() {
        MappedStructResolvedDbType stringType = new MappedStructResolvedDbType(2002, TEST_NAME, String.class);
        MappedStructResolvedDbType intType = new MappedStructResolvedDbType(2002, TEST_NAME, Integer.class);
        Assert.assertNotSame((Object)stringType.getMappedClass(), (Object)intType.getMappedClass());
        Assert.assertEquals(String.class, (Object)stringType.getMappedClass());
        Assert.assertEquals(Integer.class, (Object)intType.getMappedClass());
    }

    @Test
    public void testConstructorWithNullMappedClass() {
        MappedStructResolvedDbType nullType = new MappedStructResolvedDbType(2002, TEST_NAME, null);
        Assert.assertNull((Object)nullType.getMappedClass());
    }

    @Test
    public void testConstructorWithEmptyName() {
        MappedStructResolvedDbType emptyNameType = new MappedStructResolvedDbType(2002, "", String.class);
        Assert.assertEquals((Object)"", (Object)emptyNameType.getName());
        Assert.assertEquals(String.class, (Object)emptyNameType.getMappedClass());
    }

    @Test
    public void testConstructorWithNullName() {
        MappedStructResolvedDbType nullNameType = new MappedStructResolvedDbType(2002, null, String.class);
        Assert.assertNull((Object)nullNameType.getName());
        Assert.assertEquals(String.class, (Object)nullNameType.getMappedClass());
    }
}

