/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.ArrayResolvedDbType;
import org.mule.db.commons.internal.domain.type.BlobDbType;
import org.mule.db.commons.internal.domain.type.ClobResolvedDataType;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.DynamicDbType;
import org.mule.db.commons.internal.domain.type.MetadataDbTypeManager;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;
import org.mule.db.commons.internal.domain.type.StructDbType;
import org.mule.db.commons.internal.domain.type.UnknownDbType;
import org.mule.db.commons.internal.domain.type.UnknownDbTypeException;
import org.mule.db.commons.internal.result.resultset.ResultSetIterator;

@RunWith(value=MockitoJUnitRunner.class)
public class MetadataDbTypeManagerTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private DbConnection mockDbConnection;
    @Mock
    private Connection mockConnection;
    @Mock
    private DatabaseMetaData mockDatabaseMetaData;
    @Mock
    private ResultSet mockResultSet;
    @Mock
    private ResultSetIterator mockResultSetIterator;
    private MetadataDbTypeManager metadataDbTypeManager;

    @Before
    public void setUp() throws Exception {
        this.metadataDbTypeManager = new MetadataDbTypeManager();
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockConnection);
        Mockito.when((Object)this.mockConnection.getMetaData()).thenReturn((Object)this.mockDatabaseMetaData);
        Mockito.when((Object)this.mockDatabaseMetaData.getTypeInfo()).thenReturn((Object)this.mockResultSet);
    }

    @Test
    public void testConstructor() {
        MetadataDbTypeManager metadataDbTypeManager = new MetadataDbTypeManager();
        Assert.assertNotNull((Object)metadataDbTypeManager);
    }

    @Test
    public void testConstants() {
        Assert.assertEquals((Object)"DATA_TYPE", (Object)"DATA_TYPE");
        Assert.assertEquals((Object)"TYPE_NAME", (Object)"TYPE_NAME");
    }

    @Test
    public void testRegisterType() {
        ResolvedDbType testType = new ResolvedDbType(12, "TEST_TYPE");
        this.metadataDbTypeManager.registerType((DbType)testType);
        try {
            DbType foundType = this.metadataDbTypeManager.lookup(this.mockDbConnection, 12, "TEST_TYPE");
            Assert.assertEquals((Object)testType, (Object)foundType);
        }
        catch (UnknownDbTypeException e) {
            Assert.fail((String)"Type should have been found");
        }
    }

    @Test
    public void testRegisterTypeWithDuplicate() {
        ResolvedDbType testType1 = new ResolvedDbType(12, "TEST_TYPE");
        ResolvedDbType testType2 = new ResolvedDbType(12, "TEST_TYPE");
        this.metadataDbTypeManager.registerType((DbType)testType1);
        this.metadataDbTypeManager.registerType((DbType)testType2);
        try {
            DbType foundType = this.metadataDbTypeManager.lookup(this.mockDbConnection, 12, "TEST_TYPE");
            Assert.assertEquals((Object)testType1, (Object)foundType);
        }
        catch (UnknownDbTypeException e) {
            Assert.fail((String)"Type should have been found");
        }
    }

    @Test
    public void testLookupWithIdAndName() throws UnknownDbTypeException {
        ResolvedDbType testType = new ResolvedDbType(4, "INT_TYPE");
        this.metadataDbTypeManager.registerType((DbType)testType);
        DbType foundType = this.metadataDbTypeManager.lookup(this.mockDbConnection, 4, "INT_TYPE");
        Assert.assertEquals((Object)testType, (Object)foundType);
    }

    @Test
    public void testLookupWithIdAndNameNotFound() {
        this.expectedException.expect(UnknownDbTypeException.class);
        this.metadataDbTypeManager.lookup(this.mockDbConnection, 4, "NONEXISTENT_TYPE");
    }

    @Test
    public void testLookupWithIdAndNameWithTypesOther() throws UnknownDbTypeException {
        DbType foundType = this.metadataDbTypeManager.lookup(this.mockDbConnection, 1111, "ANY_NAME");
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)foundType);
    }

    @Test
    public void testLookupWithNameOnly() {
        this.expectedException.expect(UnknownDbTypeException.class);
        this.metadataDbTypeManager.lookup(this.mockDbConnection, "ANY_NAME");
    }

    @Test
    public void testLookupWithNameOnlyExceptionMessage() {
        try {
            this.metadataDbTypeManager.lookup(this.mockDbConnection, "TEST_NAME");
            Assert.fail((String)"Expected UnknownDbTypeException");
        }
        catch (UnknownDbTypeException e) {
            Assert.assertEquals((Object)"Unable to find a mapping for type: TEST_NAME", (Object)e.getMessage());
        }
    }

    @Test
    public void testIsUserDefinedTypeWithStruct() {
        StructDbType structType = new StructDbType(2002, "CUSTOM_STRUCT");
        Assert.assertTrue((boolean)MetadataDbTypeManager.isTypeDerivedFrom((DbType)structType, (DbType)new StructDbType(2002, "STRUCT")));
    }

    @Test
    public void testIsUserDefinedTypeWithDistinct() {
        ResolvedDbType distinctType = new ResolvedDbType(2001, "CUSTOM_DISTINCT");
        Assert.assertTrue((boolean)MetadataDbTypeManager.isTypeDerivedFrom((DbType)distinctType, (DbType)new ResolvedDbType(2001, "DISTINCT")));
    }

    @Test
    public void testIsUserDefinedTypeWithArray() {
        ArrayResolvedDbType arrayType = new ArrayResolvedDbType(2003, "CUSTOM_ARRAY");
        Assert.assertTrue((boolean)MetadataDbTypeManager.isTypeDerivedFrom((DbType)arrayType, (DbType)new ArrayResolvedDbType(2003, "ARRAY")));
    }

    @Test
    public void testIsUserDefinedTypeWithStandardType() {
        ResolvedDbType standardType = new ResolvedDbType(12, "VARCHAR");
        Assert.assertFalse((boolean)MetadataDbTypeManager.isTypeDerivedFrom((DbType)standardType, (DbType)new ResolvedDbType(12, "VARCHAR")));
    }

    @Test
    public void testIsUserDefinedTypeWithDifferentId() {
        ResolvedDbType type1 = new ResolvedDbType(12, "VARCHAR");
        ResolvedDbType type2 = new ResolvedDbType(4, "VARCHAR");
        Assert.assertFalse((boolean)MetadataDbTypeManager.isTypeDerivedFrom((DbType)type1, (DbType)type2));
    }

    @Test
    public void testIsUserDefinedTypeWithSameName() {
        ResolvedDbType type1 = new ResolvedDbType(12, "VARCHAR");
        ResolvedDbType type2 = new ResolvedDbType(12, "VARCHAR");
        Assert.assertFalse((boolean)MetadataDbTypeManager.isTypeDerivedFrom((DbType)type1, (DbType)type2));
    }

    @Test
    public void testIsUserDefinedTypeWithDifferentTypes() {
        ResolvedDbType type1 = new ResolvedDbType(12, "VARCHAR");
        StructDbType type2 = new StructDbType(2002, "STRUCT");
        Assert.assertFalse((boolean)MetadataDbTypeManager.isTypeDerivedFrom((DbType)type1, (DbType)type2));
    }

    @Test
    public void testIsTypeDerivedFromWithNullTypes() {
        try {
            MetadataDbTypeManager.isTypeDerivedFrom(null, (DbType)new ResolvedDbType(12, "VARCHAR"));
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            MetadataDbTypeManager.isTypeDerivedFrom((DbType)new ResolvedDbType(12, "VARCHAR"), null);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            MetadataDbTypeManager.isTypeDerivedFrom(null, null);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testIsTypeDerivedFromWithExactMatch() {
        ResolvedDbType type1 = new ResolvedDbType(12, "VARCHAR");
        ResolvedDbType type2 = new ResolvedDbType(12, "VARCHAR");
        Assert.assertFalse((boolean)MetadataDbTypeManager.isTypeDerivedFrom((DbType)type1, (DbType)type2));
    }

    @Test
    public void testIsTypeDerivedFromWithDifferentNames() {
        ResolvedDbType type1 = new ResolvedDbType(12, "CUSTOM_VARCHAR");
        ResolvedDbType type2 = new ResolvedDbType(12, "VARCHAR");
        Assert.assertTrue((boolean)MetadataDbTypeManager.isTypeDerivedFrom((DbType)type1, (DbType)type2));
    }

    @Test
    public void testIsTypeDerivedFromWithDifferentIds() {
        ResolvedDbType type1 = new ResolvedDbType(12, "VARCHAR");
        ResolvedDbType type2 = new ResolvedDbType(4, "VARCHAR");
        Assert.assertFalse((boolean)MetadataDbTypeManager.isTypeDerivedFrom((DbType)type1, (DbType)type2));
    }

    @Test
    public void testMultipleLookups() throws UnknownDbTypeException {
        ResolvedDbType type1 = new ResolvedDbType(12, "VARCHAR_TYPE");
        ResolvedDbType type2 = new ResolvedDbType(4, "INTEGER_TYPE");
        this.metadataDbTypeManager.registerType((DbType)type1);
        this.metadataDbTypeManager.registerType((DbType)type2);
        Assert.assertEquals((Object)type1, (Object)this.metadataDbTypeManager.lookup(this.mockDbConnection, 12, "VARCHAR_TYPE"));
        Assert.assertEquals((Object)type2, (Object)this.metadataDbTypeManager.lookup(this.mockDbConnection, 4, "INTEGER_TYPE"));
    }

    @Test
    public void testLookupInitializationLazy() throws UnknownDbTypeException {
        ResolvedDbType testType = new ResolvedDbType(12, "TEST_TYPE");
        this.metadataDbTypeManager.registerType((DbType)testType);
        DbType foundType = this.metadataDbTypeManager.lookup(this.mockDbConnection, 12, "TEST_TYPE");
        Assert.assertEquals((Object)testType, (Object)foundType);
    }

    @Test
    public void testLookupInitializationOnce() throws UnknownDbTypeException {
        ResolvedDbType testType = new ResolvedDbType(12, "TEST_TYPE");
        this.metadataDbTypeManager.registerType((DbType)testType);
        this.metadataDbTypeManager.lookup(this.mockDbConnection, 12, "TEST_TYPE");
        DbType foundType = this.metadataDbTypeManager.lookup(this.mockDbConnection, 12, "TEST_TYPE");
        Assert.assertEquals((Object)testType, (Object)foundType);
    }

    @Test
    public void testRegisterTypeWithNull() {
        try {
            this.metadataDbTypeManager.registerType(null);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testRegisterTypeWithNullName() {
        ResolvedDbType testType = new ResolvedDbType(12, null);
        this.metadataDbTypeManager.registerType((DbType)testType);
        try {
            DbType foundType = this.metadataDbTypeManager.lookup(this.mockDbConnection, 12, null);
            Assert.assertEquals((Object)testType, (Object)foundType);
        }
        catch (UnknownDbTypeException e) {
            Assert.fail((String)"Type should have been found");
        }
    }

    @Test
    public void testRegisterTypeWithEmptyName() {
        ResolvedDbType testType = new ResolvedDbType(12, "");
        this.metadataDbTypeManager.registerType((DbType)testType);
        try {
            DbType foundType = this.metadataDbTypeManager.lookup(this.mockDbConnection, 12, "");
            Assert.assertEquals((Object)testType, (Object)foundType);
        }
        catch (UnknownDbTypeException e) {
            Assert.fail((String)"Type should have been found");
        }
    }

    @Test
    public void testLookupWithNegativeId() {
        this.expectedException.expect(UnknownDbTypeException.class);
        this.metadataDbTypeManager.lookup(this.mockDbConnection, -1, "TEST_TYPE");
    }

    @Test
    public void testLookupWithZeroId() {
        this.expectedException.expect(UnknownDbTypeException.class);
        this.metadataDbTypeManager.lookup(this.mockDbConnection, 0, "TEST_TYPE");
    }

    @Test
    public void testLookupWithLargeId() {
        this.expectedException.expect(UnknownDbTypeException.class);
        this.metadataDbTypeManager.lookup(this.mockDbConnection, Integer.MAX_VALUE, "TEST_TYPE");
    }

    @Test
    public void testIsTypeDerivedFromWithBlobType() {
        BlobDbType blobType = new BlobDbType(2004, "CUSTOM_BLOB");
        BlobDbType baseBlobType = new BlobDbType(2004, "BLOB");
        Assert.assertTrue((boolean)MetadataDbTypeManager.isTypeDerivedFrom((DbType)blobType, (DbType)baseBlobType));
    }

    @Test
    public void testIsTypeDerivedFromWithClobType() {
        ClobResolvedDataType clobType = new ClobResolvedDataType(2005, "CUSTOM_CLOB");
        ClobResolvedDataType baseClobType = new ClobResolvedDataType(2005, "CLOB");
        Assert.assertTrue((boolean)MetadataDbTypeManager.isTypeDerivedFrom((DbType)clobType, (DbType)baseClobType));
    }

    @Test
    public void testIsTypeDerivedFromWithStructType() {
        StructDbType structType = new StructDbType(2002, "CUSTOM_STRUCT");
        StructDbType baseStructType = new StructDbType(2002, "STRUCT");
        Assert.assertTrue((boolean)MetadataDbTypeManager.isTypeDerivedFrom((DbType)structType, (DbType)baseStructType));
    }

    @Test
    public void testIsTypeDerivedFromWithArrayType() {
        ArrayResolvedDbType arrayType = new ArrayResolvedDbType(2003, "CUSTOM_ARRAY");
        ArrayResolvedDbType baseArrayType = new ArrayResolvedDbType(2003, "ARRAY");
        Assert.assertTrue((boolean)MetadataDbTypeManager.isTypeDerivedFrom((DbType)arrayType, (DbType)baseArrayType));
    }

    @Test
    public void testIsTypeDerivedFromWithDynamicType() {
        DynamicDbType dynamicType = new DynamicDbType("CUSTOM_DYNAMIC");
        DynamicDbType baseDynamicType = new DynamicDbType("DYNAMIC");
        try {
            MetadataDbTypeManager.isTypeDerivedFrom((DbType)dynamicType, (DbType)baseDynamicType);
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentAccess() throws InterruptedException {
        ResolvedDbType testType = new ResolvedDbType(12, "CONCURRENT_TYPE");
        this.metadataDbTypeManager.registerType((DbType)testType);
        Thread[] threads = new Thread[5];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(() -> this.lambda$testConcurrentAccess$0((DbType)testType));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
    }

    @Test
    public void testToString() {
        String toString = this.metadataDbTypeManager.toString();
        Assert.assertNotNull((Object)toString);
        Assert.assertFalse((boolean)toString.isEmpty());
    }

    @Test
    public void testEqualsAndHashCode() {
        MetadataDbTypeManager manager1 = new MetadataDbTypeManager();
        MetadataDbTypeManager manager2 = new MetadataDbTypeManager();
        Assert.assertFalse((boolean)manager1.equals(manager2));
        Assert.assertFalse((boolean)manager1.equals(null));
        Assert.assertTrue((boolean)manager1.equals(manager1));
        Assert.assertNotEquals((long)manager1.hashCode(), (long)manager2.hashCode());
    }

    private /* synthetic */ void lambda$testConcurrentAccess$0(DbType testType) {
        try {
            DbType foundType = this.metadataDbTypeManager.lookup(this.mockDbConnection, 12, "CONCURRENT_TYPE");
            Assert.assertEquals((Object)testType, (Object)foundType);
        }
        catch (UnknownDbTypeException e) {
            Assert.fail((String)"Type should have been found");
        }
    }
}

