/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.TimestampWithTimeZoneDbType;

public class TimestampWithTimeZoneDbTypeTestCase {
    private static final int PARAM_INDEX = 1;
    private PreparedStatement mockPreparedStatement;
    private CallableStatement mockCallableStatement;
    private DbConnection mockDbConnection;
    private TimestampWithTimeZoneDbType timestampWithTimeZoneDbType;

    @Before
    public void setUp() {
        this.mockPreparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.mockCallableStatement = (CallableStatement)Mockito.mock(CallableStatement.class);
        this.mockDbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        this.timestampWithTimeZoneDbType = new TimestampWithTimeZoneDbType(-102, "TIMESTAMP WITH TIME ZONE");
    }

    @Test
    public void testConstantValue() {
        MatcherAssert.assertThat((Object)-102, (Matcher)CoreMatchers.is((Object)-102));
    }

    @Test
    public void testSetParameterValueWithStringValue() throws SQLException {
        String value = "2023-10-05T15:39:20.045+02:00";
        this.timestampWithTimeZoneDbType.setParameterValue(this.mockPreparedStatement, 1, (Object)value, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setObject(1, value);
    }

    @Test
    public void testSetParameterValueWithTimestampValue() throws SQLException {
        Timestamp value = Timestamp.valueOf("2023-10-05 15:39:20.045");
        this.timestampWithTimeZoneDbType.setParameterValue(this.mockPreparedStatement, 1, (Object)value, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setObject(1, value);
    }

    @Test
    public void testSetParameterValueWithNullValue() throws SQLException {
        this.timestampWithTimeZoneDbType.setParameterValue(this.mockPreparedStatement, 1, null, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setNull(1, -102);
    }

    @Test
    public void testGetParameterValue() throws SQLException {
        String expectedValue = "2023-10-05T15:39:20.045+02:00";
        Mockito.when((Object)this.mockCallableStatement.getObject(1)).thenReturn((Object)expectedValue);
        Object actualValue = this.timestampWithTimeZoneDbType.getParameterValue(this.mockCallableStatement, 1);
        MatcherAssert.assertThat((Object)actualValue, (Matcher)CoreMatchers.is((Object)expectedValue));
        ((CallableStatement)Mockito.verify((Object)this.mockCallableStatement)).getObject(1);
    }

    @Test
    public void testGetParameterValueReturnsNull() throws SQLException {
        Mockito.when((Object)this.mockCallableStatement.getObject(1)).thenReturn(null);
        Object actualValue = this.timestampWithTimeZoneDbType.getParameterValue(this.mockCallableStatement, 1);
        MatcherAssert.assertThat((Object)actualValue, (Matcher)CoreMatchers.is(null));
        ((CallableStatement)Mockito.verify((Object)this.mockCallableStatement)).getObject(1);
    }

    @Test
    public void testGetIdReturnsCorrectValue() {
        MatcherAssert.assertThat((Object)this.timestampWithTimeZoneDbType.getId(), (Matcher)CoreMatchers.is((Object)-102));
    }

    @Test
    public void testGetNameReturnsCorrectValue() {
        MatcherAssert.assertThat((Object)this.timestampWithTimeZoneDbType.getName(), (Matcher)CoreMatchers.is((Object)"TIMESTAMP WITH TIME ZONE"));
    }
}

